/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCommandBufferInheritanceInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RENDERPASS;
    public static final int SUBPASS;
    public static final int FRAMEBUFFER;
    public static final int OCCLUSIONQUERYENABLE;
    public static final int QUERYFLAGS;
    public static final int PIPELINESTATISTICS;

    public VkCommandBufferInheritanceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCommandBufferInheritanceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCommandBufferInheritanceInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCommandBufferInheritanceInfo.npNext(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkCommandBufferInheritanceInfo.nrenderPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int subpass() {
        return VkCommandBufferInheritanceInfo.nsubpass(this.address());
    }

    @NativeType(value="VkFramebuffer")
    public long framebuffer() {
        return VkCommandBufferInheritanceInfo.nframebuffer(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean occlusionQueryEnable() {
        return VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address()) != 0;
    }

    @NativeType(value="VkQueryControlFlags")
    public int queryFlags() {
        return VkCommandBufferInheritanceInfo.nqueryFlags(this.address());
    }

    @NativeType(value="VkQueryPipelineStatisticFlags")
    public int pipelineStatistics() {
        return VkCommandBufferInheritanceInfo.npipelineStatistics(this.address());
    }

    public VkCommandBufferInheritanceInfo sType(@NativeType(value="VkStructureType") int value) {
        VkCommandBufferInheritanceInfo.nsType(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo pNext(@NativeType(value="void const *") long value) {
        VkCommandBufferInheritanceInfo.npNext(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkCommandBufferInheritanceInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo subpass(@NativeType(value="uint32_t") int value) {
        VkCommandBufferInheritanceInfo.nsubpass(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo framebuffer(@NativeType(value="VkFramebuffer") long value) {
        VkCommandBufferInheritanceInfo.nframebuffer(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo occlusionQueryEnable(@NativeType(value="VkBool32") boolean value) {
        VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkCommandBufferInheritanceInfo queryFlags(@NativeType(value="VkQueryControlFlags") int value) {
        VkCommandBufferInheritanceInfo.nqueryFlags(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
        VkCommandBufferInheritanceInfo.npipelineStatistics(this.address(), value);
        return this;
    }

    public VkCommandBufferInheritanceInfo set(int sType, long pNext, long renderPass, int subpass, long framebuffer, boolean occlusionQueryEnable, int queryFlags, int pipelineStatistics) {
        this.sType(sType);
        this.pNext(pNext);
        this.renderPass(renderPass);
        this.subpass(subpass);
        this.framebuffer(framebuffer);
        this.occlusionQueryEnable(occlusionQueryEnable);
        this.queryFlags(queryFlags);
        this.pipelineStatistics(pipelineStatistics);
        return this;
    }

    public VkCommandBufferInheritanceInfo set(VkCommandBufferInheritanceInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCommandBufferInheritanceInfo malloc() {
        return (VkCommandBufferInheritanceInfo)VkCommandBufferInheritanceInfo.wrap(VkCommandBufferInheritanceInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo calloc() {
        return (VkCommandBufferInheritanceInfo)VkCommandBufferInheritanceInfo.wrap(VkCommandBufferInheritanceInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkCommandBufferInheritanceInfo)VkCommandBufferInheritanceInfo.wrap(VkCommandBufferInheritanceInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkCommandBufferInheritanceInfo create(long address) {
        return (VkCommandBufferInheritanceInfo)VkCommandBufferInheritanceInfo.wrap(VkCommandBufferInheritanceInfo.class, (long)address);
    }

    @Nullable
    public static VkCommandBufferInheritanceInfo createSafe(long address) {
        return address == 0L ? null : (VkCommandBufferInheritanceInfo)VkCommandBufferInheritanceInfo.wrap(VkCommandBufferInheritanceInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkCommandBufferInheritanceInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkCommandBufferInheritanceInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkCommandBufferInheritanceInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCommandBufferInheritanceInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkCommandBufferInheritanceInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkCommandBufferInheritanceInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkCommandBufferInheritanceInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkCommandBufferInheritanceInfo mallocStack() {
        return VkCommandBufferInheritanceInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferInheritanceInfo callocStack() {
        return VkCommandBufferInheritanceInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkCommandBufferInheritanceInfo mallocStack(MemoryStack stack) {
        return (VkCommandBufferInheritanceInfo)VkCommandBufferInheritanceInfo.wrap(VkCommandBufferInheritanceInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCommandBufferInheritanceInfo callocStack(MemoryStack stack) {
        return (VkCommandBufferInheritanceInfo)VkCommandBufferInheritanceInfo.wrap(VkCommandBufferInheritanceInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCommandBufferInheritanceInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCommandBufferInheritanceInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkCommandBufferInheritanceInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkCommandBufferInheritanceInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nrenderPass(long struct) {
        return UNSAFE.getLong(null, struct + (long)RENDERPASS);
    }

    public static int nsubpass(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBPASS);
    }

    public static long nframebuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)FRAMEBUFFER);
    }

    public static int nocclusionQueryEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)OCCLUSIONQUERYENABLE);
    }

    public static int nqueryFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUERYFLAGS);
    }

    public static int npipelineStatistics(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINESTATISTICS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nrenderPass(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RENDERPASS, value);
    }

    public static void nsubpass(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBPASS, value);
    }

    public static void nframebuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FRAMEBUFFER, value);
    }

    public static void nocclusionQueryEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OCCLUSIONQUERYENABLE, value);
    }

    public static void nqueryFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUERYFLAGS, value);
    }

    public static void npipelineStatistics(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINESTATISTICS, value);
    }

    static {
        Struct.Layout layout = VkCommandBufferInheritanceInfo.__struct((Struct.Member[])new Struct.Member[]{VkCommandBufferInheritanceInfo.__member((int)4), VkCommandBufferInheritanceInfo.__member((int)POINTER_SIZE), VkCommandBufferInheritanceInfo.__member((int)8), VkCommandBufferInheritanceInfo.__member((int)4), VkCommandBufferInheritanceInfo.__member((int)8), VkCommandBufferInheritanceInfo.__member((int)4), VkCommandBufferInheritanceInfo.__member((int)4), VkCommandBufferInheritanceInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RENDERPASS = layout.offsetof(2);
        SUBPASS = layout.offsetof(3);
        FRAMEBUFFER = layout.offsetof(4);
        OCCLUSIONQUERYENABLE = layout.offsetof(5);
        QUERYFLAGS = layout.offsetof(6);
        PIPELINESTATISTICS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkCommandBufferInheritanceInfo, Buffer>
    implements NativeResource {
        private static final VkCommandBufferInheritanceInfo ELEMENT_FACTORY = VkCommandBufferInheritanceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCommandBufferInheritanceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCommandBufferInheritanceInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCommandBufferInheritanceInfo.npNext(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkCommandBufferInheritanceInfo.nrenderPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int subpass() {
            return VkCommandBufferInheritanceInfo.nsubpass(this.address());
        }

        @NativeType(value="VkFramebuffer")
        public long framebuffer() {
            return VkCommandBufferInheritanceInfo.nframebuffer(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean occlusionQueryEnable() {
            return VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address()) != 0;
        }

        @NativeType(value="VkQueryControlFlags")
        public int queryFlags() {
            return VkCommandBufferInheritanceInfo.nqueryFlags(this.address());
        }

        @NativeType(value="VkQueryPipelineStatisticFlags")
        public int pipelineStatistics() {
            return VkCommandBufferInheritanceInfo.npipelineStatistics(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCommandBufferInheritanceInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCommandBufferInheritanceInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkCommandBufferInheritanceInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer subpass(@NativeType(value="uint32_t") int value) {
            VkCommandBufferInheritanceInfo.nsubpass(this.address(), value);
            return this;
        }

        public Buffer framebuffer(@NativeType(value="VkFramebuffer") long value) {
            VkCommandBufferInheritanceInfo.nframebuffer(this.address(), value);
            return this;
        }

        public Buffer occlusionQueryEnable(@NativeType(value="VkBool32") boolean value) {
            VkCommandBufferInheritanceInfo.nocclusionQueryEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer queryFlags(@NativeType(value="VkQueryControlFlags") int value) {
            VkCommandBufferInheritanceInfo.nqueryFlags(this.address(), value);
            return this;
        }

        public Buffer pipelineStatistics(@NativeType(value="VkQueryPipelineStatisticFlags") int value) {
            VkCommandBufferInheritanceInfo.npipelineStatistics(this.address(), value);
            return this;
        }
    }
}

