/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkSemaphoreSignalInfo;
import org.lwjgl.vulkan.VkSemaphoreWaitInfo;

public class KHRTimelineSemaphore {
    public static final int VK_KHR_TIMELINE_SEMAPHORE_SPEC_VERSION = 2;
    public static final String VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME = "VK_KHR_timeline_semaphore";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR = 1000207000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR = 1000207001;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR = 1000207002;
    public static final int VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR = 1000207003;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR = 1000207004;
    public static final int VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR = 1000207005;
    public static final int VK_SEMAPHORE_TYPE_BINARY_KHR = 0;
    public static final int VK_SEMAPHORE_TYPE_TIMELINE_KHR = 1;
    public static final int VK_SEMAPHORE_WAIT_ANY_BIT_KHR = 1;

    protected KHRTimelineSemaphore() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME) && VK.checkExtension(VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME, VK.isSupported(provider, "vkGetSemaphoreCounterValueKHR", caps) && VK.isSupported(provider, "vkWaitSemaphoresKHR", caps) && VK.isSupported(provider, "vkSignalSemaphoreKHR", caps));
    }

    public static int nvkGetSemaphoreCounterValueKHR(VkDevice device, long semaphore, long pValue) {
        long __functionAddress = device.getCapabilities().vkGetSemaphoreCounterValueKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)semaphore, (long)pValue, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetSemaphoreCounterValueKHR(VkDevice device, @NativeType(value="VkSemaphore") long semaphore, @NativeType(value="uint64_t *") LongBuffer pValue) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pValue, (int)1);
        }
        return KHRTimelineSemaphore.nvkGetSemaphoreCounterValueKHR(device, semaphore, MemoryUtil.memAddress((LongBuffer)pValue));
    }

    public static int nvkWaitSemaphoresKHR(VkDevice device, long pWaitInfo, long timeout) {
        long __functionAddress = device.getCapabilities().vkWaitSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkSemaphoreWaitInfo.validate(pWaitInfo);
        }
        return JNI.callPPJI((long)device.address(), (long)pWaitInfo, (long)timeout, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkWaitSemaphoresKHR(VkDevice device, @NativeType(value="VkSemaphoreWaitInfo const *") VkSemaphoreWaitInfo pWaitInfo, @NativeType(value="uint64_t") long timeout) {
        return KHRTimelineSemaphore.nvkWaitSemaphoresKHR(device, pWaitInfo.address(), timeout);
    }

    public static int nvkSignalSemaphoreKHR(VkDevice device, long pSignalInfo) {
        long __functionAddress = device.getCapabilities().vkSignalSemaphoreKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)device.address(), (long)pSignalInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkSignalSemaphoreKHR(VkDevice device, @NativeType(value="VkSemaphoreSignalInfo const *") VkSemaphoreSignalInfo pSignalInfo) {
        return KHRTimelineSemaphore.nvkSignalSemaphoreKHR(device, pSignalInfo.address());
    }

    @NativeType(value="VkResult")
    public static int vkGetSemaphoreCounterValueKHR(VkDevice device, @NativeType(value="VkSemaphore") long semaphore, @NativeType(value="uint64_t *") long[] pValue) {
        long __functionAddress = device.getCapabilities().vkGetSemaphoreCounterValueKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pValue, (int)1);
        }
        return JNI.callPJPI((long)device.address(), (long)semaphore, (long[])pValue, (long)__functionAddress);
    }
}

