/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.msgpack.jruby.ExtensionRegistry;
import org.msgpack.jruby.Packer;
import org.msgpack.jruby.Unpacker;

@JRubyClass(name={"MessagePack::Factory"})
public class Factory
extends RubyObject {
    private static final long serialVersionUID = 8441284623445322492L;
    private final Ruby runtime;
    private ExtensionRegistry extensionRegistry;
    private boolean hasSymbolExtType;
    private boolean hasBigIntExtType;

    public Factory(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.runtime = ruby;
        this.extensionRegistry = new ExtensionRegistry();
        this.hasSymbolExtType = false;
        this.hasBigIntExtType = false;
    }

    public ExtensionRegistry extensionRegistry() {
        return this.extensionRegistry.dup();
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        Factory factory = (Factory)super.dup();
        factory.extensionRegistry = this.extensionRegistry();
        factory.hasSymbolExtType = this.hasSymbolExtType;
        return factory;
    }

    @JRubyMethod(name={"packer"}, optional=2)
    public Packer packer(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return Packer.newPacker(threadContext, this.extensionRegistry(), this.hasSymbolExtType, this.hasBigIntExtType, iRubyObjectArray);
    }

    @JRubyMethod(name={"unpacker"}, optional=2)
    public Unpacker unpacker(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return Unpacker.newUnpacker(threadContext, this.extensionRegistry(), iRubyObjectArray);
    }

    @JRubyMethod(name={"registered_types_internal"}, visibility=Visibility.PRIVATE)
    public IRubyObject registeredTypesInternal(ThreadContext threadContext) {
        return RubyArray.newArray((Ruby)threadContext.runtime, (IRubyObject[])new IRubyObject[]{this.extensionRegistry.toInternalPackerRegistry(threadContext), this.extensionRegistry.toInternalUnpackerRegistry(threadContext)});
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(name={"register_type"}, required=2, optional=1)
    public IRubyObject registerType(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        void var13_17;
        IRubyObject iRubyObject;
        RubySymbol rubySymbol;
        RubySymbol rubySymbol2;
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = iRubyObjectArray[1];
        RubyHash rubyHash = null;
        if (this.isFrozen()) {
            throw ruby.newRuntimeError("can't modify frozen Factory");
        }
        if (iRubyObjectArray.length == 2) {
            rubySymbol2 = ruby.newSymbol("to_msgpack_ext");
            rubySymbol = ruby.newSymbol("from_msgpack_ext");
        } else {
            if (iRubyObjectArray.length != 3) throw ruby.newArgumentError(String.format("wrong number of arguments (%d for 2..3)", 2 + iRubyObjectArray.length));
            if (!(iRubyObjectArray[iRubyObjectArray.length - 1] instanceof RubyHash)) throw ruby.newArgumentError(String.format("expected Hash but found %s.", iRubyObjectArray[iRubyObjectArray.length - 1].getType().getName()));
            rubyHash = (RubyHash)iRubyObjectArray[iRubyObjectArray.length - 1];
            rubySymbol2 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("packer"));
            rubySymbol = rubyHash.fastARef((IRubyObject)ruby.newSymbol("unpacker"));
            IRubyObject iRubyObject4 = rubyHash.fastARef((IRubyObject)ruby.newSymbol("optimized_symbols_parsing"));
            if (iRubyObject4 != null && iRubyObject4.isTrue()) {
                throw ruby.newArgumentError("JRuby implementation does not support the optimized_symbols_parsing option");
            }
        }
        long l = ((RubyFixnum)iRubyObject2).getLongValue();
        if (l < -128L || l > 127L) {
            throw ruby.newRangeError(String.format("integer %d too big to convert to `signed char'", l));
        }
        if (!(iRubyObject3 instanceof RubyModule)) {
            throw ruby.newArgumentError(String.format("expected Module/Class but found %s.", iRubyObject3.getType().getName()));
        }
        RubyModule rubyModule = (RubyModule)iRubyObject3;
        IRubyObject iRubyObject5 = ruby.getNil();
        IRubyObject iRubyObject6 = ruby.getNil();
        if (rubySymbol2 != null) {
            iRubyObject5 = rubySymbol2.callMethod(threadContext, "to_proc");
        }
        if (rubySymbol != null) {
            if (rubySymbol instanceof RubyString || rubySymbol instanceof RubySymbol) {
                IRubyObject iRubyObject7 = rubyModule.method(rubySymbol.callMethod(threadContext, "to_sym"));
            } else if (rubySymbol instanceof RubyProc || rubySymbol instanceof RubyMethod) {
                RubySymbol rubySymbol3 = rubySymbol;
            } else {
                IRubyObject iRubyObject8 = rubySymbol.callMethod(threadContext, "method", (IRubyObject)ruby.newSymbol("call"));
            }
        }
        boolean bl = false;
        if (rubyHash != null && (iRubyObject = rubyHash.fastARef((IRubyObject)ruby.newSymbol("recursive"))) != null && iRubyObject.isTrue()) {
            bl = true;
        }
        this.extensionRegistry.put(rubyModule, (int)l, bl, iRubyObject5, (IRubyObject)rubySymbol2, (IRubyObject)var13_17, (IRubyObject)rubySymbol);
        if (rubyModule == ruby.getSymbol()) {
            this.hasSymbolExtType = true;
        }
        if (rubyHash == null || (iRubyObject = rubyHash.fastARef((IRubyObject)ruby.newSymbol("oversized_integer_extension"))) == null || !iRubyObject.isTrue()) return ruby.getNil();
        if (rubyModule != ruby.getModule("Integer")) throw ruby.newArgumentError("oversized_integer_extension: true is only for Integer class");
        this.hasBigIntExtType = true;
        return ruby.getNil();
    }

    static class FactoryAllocator
    implements ObjectAllocator {
        FactoryAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Factory(ruby, rubyClass);
        }
    }
}

