/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.monitors;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HotThreadsMonitor {
    private static final String ORDERED_BY = "ordered_by";
    private static final String STACKTRACE_SIZE = "stacktrace_size";
    private static final Logger logger = LogManager.getLogger(HotThreadsMonitor.class);
    private static final Collection<String> VALID_ORDER_BY = new HashSet<String>(Arrays.asList("cpu", "wait", "block"));

    private HotThreadsMonitor() {
    }

    public static List<ThreadReport> detect() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(ORDERED_BY, "cpu");
        return HotThreadsMonitor.detect(options);
    }

    public static List<ThreadReport> detect(Map<String, String> options) {
        String type = "cpu";
        if (options.containsKey(ORDERED_BY) && !HotThreadsMonitor.isValidSortOrder(type = options.get(ORDERED_BY))) {
            throw new IllegalArgumentException("Invalid sort order");
        }
        Integer threadInfoMaxDepth = 50;
        if (options.containsKey(STACKTRACE_SIZE)) {
            threadInfoMaxDepth = Integer.valueOf(options.get(STACKTRACE_SIZE));
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        HotThreadsMonitor.enableCpuTime(threadMXBean);
        HashMap<Long, ThreadReport> reports = new HashMap<Long, ThreadReport>();
        for (long threadId : threadMXBean.getAllThreadIds()) {
            ThreadInfo info;
            long cpuTime;
            if (Thread.currentThread().getId() == threadId || (cpuTime = threadMXBean.getThreadCpuTime(threadId)) == -1L || (info = threadMXBean.getThreadInfo(threadId, (int)threadInfoMaxDepth)) == null) continue;
            reports.put(threadId, new ThreadReport(info, cpuTime));
        }
        return HotThreadsMonitor.sort(new ArrayList<ThreadReport>(reports.values()), type);
    }

    private static List<ThreadReport> sort(List<ThreadReport> reports, String type) {
        reports.sort(HotThreadsMonitor.comparatorForOrderType(type));
        return reports;
    }

    private static Comparator<ThreadReport> comparatorForOrderType(String type) {
        if ("block".equals(type)) {
            return Comparator.comparingLong(ThreadReport::getBlockedTime).reversed();
        }
        if ("wait".equals(type)) {
            return Comparator.comparingLong(ThreadReport::getWaitedTime).reversed();
        }
        return Comparator.comparingLong(ThreadReport::getCpuTime).reversed();
    }

    private static boolean isValidSortOrder(String type) {
        return VALID_ORDER_BY.contains(type.toLowerCase());
    }

    private static void enableCpuTime(ThreadMXBean threadMXBean) {
        try {
            if (threadMXBean.isThreadCpuTimeSupported() && !threadMXBean.isThreadCpuTimeEnabled()) {
                threadMXBean.setThreadCpuTimeEnabled(true);
            }
        }
        catch (SecurityException ex) {
            logger.debug("Cannot enable Thread Cpu Time", (Throwable)ex);
        }
    }

    public static class ThreadReport {
        private static final String CPU_TIME = "cpu.time";
        private static final String BLOCKED_COUNT = "blocked.count";
        private static final String BLOCKED_TIME = "blocked.time";
        private static final String WAITED_COUNT = "waited.count";
        private static final String WAITED_TIME = "waited.time";
        private static final String THREAD_NAME = "thread.name";
        private static final String THREAD_STATE = "thread.state";
        private static final String THREAD_STACKTRACE = "thread.stacktrace";
        private static final String THREAD_ID = "thread.id";
        private Map<String, Object> map = new HashMap<String, Object>();

        ThreadReport(ThreadInfo info, long cpuTime) {
            this.map.put(CPU_TIME, cpuTime);
            this.map.put(BLOCKED_COUNT, info.getBlockedCount());
            this.map.put(BLOCKED_TIME, info.getBlockedTime());
            this.map.put(WAITED_COUNT, info.getWaitedCount());
            this.map.put(WAITED_TIME, info.getWaitedTime());
            this.map.put(THREAD_NAME, info.getThreadName());
            this.map.put(THREAD_ID, info.getThreadId());
            this.map.put(THREAD_STATE, info.getThreadState().name().toLowerCase());
            this.map.put(THREAD_STACKTRACE, ThreadReport.stackTraceAsString(info.getStackTrace()));
        }

        private static List<String> stackTraceAsString(StackTraceElement[] elements) {
            return Arrays.stream(elements).map(StackTraceElement::toString).collect(Collectors.toList());
        }

        public Map<String, Object> toMap() {
            return this.map;
        }

        public String getThreadName() {
            return (String)this.map.get(THREAD_NAME);
        }

        public long getThreadId() {
            return (Long)this.map.get(THREAD_ID);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Map.Entry<String, Object> mapEntry : this.map.entrySet()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(String.format("%s,%s", mapEntry.getKey(), mapEntry.getValue()));
                ++i;
            }
            return sb.toString();
        }

        Long getWaitedTime() {
            return (Long)this.map.get(WAITED_TIME);
        }

        Long getBlockedTime() {
            return (Long)this.map.get(BLOCKED_TIME);
        }

        Long getCpuTime() {
            return (Long)this.map.get(CPU_TIME);
        }
    }
}

