/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.PageCreator;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.FileTreeNodeFactoryProvider;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.view.data.TreeNodeBean;

public class ImageFileTreeNodeFactoryProvider
extends FileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(ImageFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/file-image.gif"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.gif", "*:file:*.jpg", "*:file:*.png");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)ICON));
    }

    protected static class ImagePage
    extends JPanel
    implements UriGettable {
        protected Container.Entry entry;

        public ImagePage(Container.Entry entry) {
            block14: {
                super(new BorderLayout());
                this.entry = entry;
                try (InputStream is = entry.getInputStream();){
                    JScrollPane scrollPane = new JScrollPane(new JLabel(new ImageIcon(ImageIO.read(is))));
                    scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
                    scrollPane.getVerticalScrollBar().setUnitIncrement(16);
                    this.add((Component)scrollPane, "Center");
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block14;
                    throw new AssertionError();
                }
            }
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }
    }

    protected static class TreeNode
    extends FileTreeNodeFactoryProvider.TreeNode
    implements PageCreator {
        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            return (T)new ImagePage(this.entry);
        }
    }
}

