/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.sam.Handler;
import net.i2p.sam.SAMBridge;
import net.i2p.sam.SAMv3Handler;
import net.i2p.sam.Session;
import net.i2p.sam.SessionRecord;
import net.i2p.sam.UTF8Reader;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

class SAMv3DatagramServer
implements Handler {
    private final DatagramChannel _server;
    private final Thread _listener;
    private final SAMBridge _parent;
    private final String _host;
    private final int _port;

    public SAMv3DatagramServer(SAMBridge parent, String host, int port, Properties props) throws IOException {
        this._parent = parent;
        this._server = DatagramChannel.open();
        this._server.socket().bind(new InetSocketAddress(host, port));
        this._listener = new I2PAppThread(new Listener(this._server), "SAM DatagramListener " + port);
        this._host = host;
        this._port = port;
    }

    public synchronized void start() {
        this._listener.start();
        if (this._parent != null) {
            this._parent.register(this);
        }
    }

    @Override
    public synchronized void stopHandling() {
        try {
            this._server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._listener.interrupt();
        if (this._parent != null) {
            this._parent.unregister(this);
        }
    }

    public void send(SocketAddress addr, ByteBuffer msg) throws IOException {
        this._server.send(msg, addr);
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    private static class MessageDispatcher
    implements Runnable {
        private final ByteArrayInputStream is;
        private static final int MAX_LINE_LENGTH = 2048;

        public MessageDispatcher(byte[] buf) {
            this.is = new ByteArrayInputStream(buf);
        }

        @Override
        public void run() {
            block29: {
                try {
                    String header;
                    StringTokenizer tok;
                    int c;
                    UTF8Reader reader = new UTF8Reader(this.is);
                    StringBuilder buf = new StringBuilder(2048);
                    int i = 0;
                    while ((c = reader.read()) != -1) {
                        if (++i > 2048) {
                            throw new IOException("Line too long - max 2048");
                        }
                        if (c == 10) break;
                        buf.append((char)c);
                    }
                    if ((tok = new StringTokenizer(header = buf.toString(), " ")).countTokens() < 3) {
                        MessageDispatcher.warn("Bad datagram header received");
                        return;
                    }
                    String version = tok.nextToken();
                    if (!version.startsWith("3.")) {
                        MessageDispatcher.warn("Bad datagram header received");
                        return;
                    }
                    String nick = tok.nextToken();
                    String dest = tok.nextToken();
                    SessionRecord rec = SAMv3Handler.sSessionsHash.get(nick);
                    if (rec != null) {
                        Properties sprops = rec.getProps();
                        String pr = sprops.getProperty("PROTOCOL");
                        String fp = sprops.getProperty("FROM_PORT");
                        String tp = sprops.getProperty("TO_PORT");
                        String st = sprops.getProperty("crypto.tagsToSend");
                        String tt = sprops.getProperty("crypto.lowTagThreshold");
                        String sl = sprops.getProperty("shouldBundleReplyInfo");
                        String exms = sprops.getProperty("clientMessageTimeout");
                        String exs = null;
                        while (tok.hasMoreTokens()) {
                            String t = tok.nextToken();
                            if (t.startsWith("PROTOCOL=")) {
                                pr = t.substring("PROTOCOL=".length());
                                continue;
                            }
                            if (t.startsWith("FROM_PORT=")) {
                                fp = t.substring("FROM_PORT=".length());
                                continue;
                            }
                            if (t.startsWith("TO_PORT=")) {
                                tp = t.substring("TO_PORT=".length());
                                continue;
                            }
                            if (t.startsWith("SEND_TAGS=")) {
                                st = t.substring("SEND_TAGS=".length());
                                continue;
                            }
                            if (t.startsWith("TAG_THRESHOLD=")) {
                                tt = t.substring("TAG_THRESHOLD=".length());
                                continue;
                            }
                            if (t.startsWith("EXPIRES=")) {
                                exs = t.substring("EXPIRES=".length());
                                continue;
                            }
                            if (!t.startsWith("SEND_LEASESET=")) continue;
                            sl = t.substring("SEND_LEASESET=".length());
                        }
                        int proto = 0;
                        int fromPort = 0;
                        int toPort = 0;
                        int sendTags = 0;
                        int tagThreshold = 0;
                        int expires = 0;
                        boolean sendLeaseSet = true;
                        try {
                            if (pr != null) {
                                proto = Integer.parseInt(pr);
                            }
                            if (fp != null) {
                                fromPort = Integer.parseInt(fp);
                            }
                            if (tp != null) {
                                toPort = Integer.parseInt(tp);
                            }
                            if (st != null) {
                                sendTags = Integer.parseInt(st);
                            }
                            if (tt != null) {
                                tagThreshold = Integer.parseInt(tt);
                            }
                            if (exs != null) {
                                expires = Integer.parseInt(exs);
                            } else if (exms != null) {
                                expires = Integer.parseInt(exms) / 1000;
                            }
                            if (sl != null) {
                                sendLeaseSet = Boolean.parseBoolean(sl);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            MessageDispatcher.warn("Bad datagram header received");
                            return;
                        }
                        byte[] data = new byte[this.is.available()];
                        this.is.read(data);
                        Session sess = rec.getHandler().getSession();
                        if (sess != null) {
                            if (sendTags > 0 || tagThreshold > 0 || expires > 0 || !sendLeaseSet) {
                                sess.sendBytes(dest, data, proto, fromPort, toPort, sendLeaseSet, sendTags, tagThreshold, expires);
                            } else {
                                sess.sendBytes(dest, data, proto, fromPort, toPort);
                            }
                        } else {
                            MessageDispatcher.warn("Dropping datagram, no session for " + nick);
                        }
                        break block29;
                    }
                    MessageDispatcher.warn("Dropping datagram, no session for " + nick);
                }
                catch (Exception e) {
                    MessageDispatcher.warn("Error handling datagram", e);
                }
            }
        }

        private static void warn(String s) {
            MessageDispatcher.warn(s, null);
        }

        private static void warn(String s, Throwable t) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(SAMv3DatagramServer.class);
            if (log.shouldLog(30)) {
                log.warn(s, t);
            }
        }
    }

    private class Listener
    implements Runnable {
        private final DatagramChannel server;

        public Listener(DatagramChannel server) {
            this.server = server;
        }

        @Override
        public void run() {
            I2PAppContext.getGlobalContext().portMapper().register("SAM-UDP", SAMv3DatagramServer.this._host, SAMv3DatagramServer.this._port);
            try {
                this.run2();
            }
            finally {
                I2PAppContext.getGlobalContext().portMapper().unregister("SAM-UDP");
            }
        }

        private void run2() {
            ByteBuffer inBuf = ByteBuffer.allocateDirect(33792);
            while (!Thread.interrupted()) {
                ((Buffer)inBuf).clear();
                try {
                    this.server.receive(inBuf);
                }
                catch (IOException e) {
                    break;
                }
                ((Buffer)inBuf).flip();
                ByteBuffer outBuf = ByteBuffer.wrap(new byte[inBuf.remaining()]);
                outBuf.put(inBuf);
                ((Buffer)outBuf).flip();
                new MessageDispatcher(outBuf.array()).run();
            }
        }
    }
}

