/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.util.Arrays;
import net.i2p.data.Base64;
import net.i2p.util.RandomSource;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SipHash;

public class SessionTag {
    public static final int BYTE_LENGTH = 32;
    private final int _cachedHashCode;
    private final byte[] _data;

    public SessionTag() {
        this._data = SimpleByteCache.acquire(32);
        RandomSource.getInstance().nextBytes(this._data);
        this._cachedHashCode = SipHash.hashCode(this._data);
    }

    public SessionTag(boolean create) {
        this();
    }

    public SessionTag(byte[] val) {
        if (val.length != 32) {
            throw new IllegalArgumentException();
        }
        this._data = val;
        this._cachedHashCode = SipHash.hashCode(val);
    }

    public byte[] getData() {
        return this._data;
    }

    public int length() {
        return 32;
    }

    public int hashCode() {
        return this._cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SessionTag)) {
            return false;
        }
        return Arrays.equals(this._data, ((SessionTag)obj)._data);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[SessionTag: ");
        if (this._data == null) {
            buf.append("null");
        } else {
            buf.append(Base64.encode(this._data));
        }
        buf.append(']');
        return buf.toString();
    }
}

