/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.sms;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSAsyncClientBuilder;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.sms.SmsManager;

public class SnsSmsClient
implements SmsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnsSmsClient.class);
    private final AmazonSNSAsync snsClient;

    public SnsSmsClient(Config config) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(config.getString(Keys.SMS_AWS_ACCESS), config.getString(Keys.SMS_AWS_SECRET));
        this.snsClient = (AmazonSNSAsync)((AmazonSNSAsyncClientBuilder)((AmazonSNSAsyncClientBuilder)AmazonSNSAsyncClientBuilder.standard().withRegion(config.getString(Keys.SMS_AWS_REGION))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).build();
    }

    @Override
    public void sendMessage(String destAddress, String message, boolean command) {
        HashMap<String, MessageAttributeValue> smsAttributes = new HashMap<String, MessageAttributeValue>();
        smsAttributes.put("AWS.SNS.SMS.SenderID", new MessageAttributeValue().withStringValue("SNS").withDataType("String"));
        smsAttributes.put("AWS.SNS.SMS.SMSType", new MessageAttributeValue().withStringValue("Transactional").withDataType("String"));
        PublishRequest publishRequest = new PublishRequest().withMessage(message).withPhoneNumber(destAddress).withMessageAttributes(smsAttributes);
        this.snsClient.publishAsync(publishRequest, (AsyncHandler)new AsyncHandler<PublishRequest, PublishResult>(){

            public void onError(Exception exception) {
                LOGGER.error("SMS send failed", (Throwable)exception);
            }

            public void onSuccess(PublishRequest request, PublishResult result) {
            }
        });
    }
}

