/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.state;

import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.state.OverspeedState;

public final class OverspeedProcessor {
    public static final String ATTRIBUTE_SPEED = "speed";

    private OverspeedProcessor() {
    }

    public static void updateState(OverspeedState state, Position position, double speedLimit, long minimalDuration, long geofenceId) {
        state.setEvent(null);
        boolean oldState = state.getOverspeedState();
        if (oldState) {
            boolean newState;
            boolean bl = newState = position.getSpeed() > speedLimit;
            if (newState) {
                if (state.getOverspeedTime() != null) {
                    long oldTime = state.getOverspeedTime().getTime();
                    long newTime = position.getFixTime().getTime();
                    if (newTime - oldTime > minimalDuration) {
                        Event event = new Event("deviceOverspeed", position);
                        event.set(ATTRIBUTE_SPEED, position.getSpeed());
                        event.set("speedLimit", speedLimit);
                        event.setGeofenceId(state.getOverspeedGeofenceId());
                        state.setOverspeedTime(null);
                        state.setOverspeedGeofenceId(0L);
                        state.setEvent(event);
                    }
                }
            } else {
                state.setOverspeedState(false);
                state.setOverspeedTime(null);
                state.setOverspeedGeofenceId(0L);
            }
        } else if (position != null && position.getSpeed() > speedLimit) {
            state.setOverspeedState(true);
            state.setOverspeedTime(position.getFixTime());
            state.setOverspeedGeofenceId(geofenceId);
        }
    }
}

