/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import com.google.inject.Injector;
import com.google.inject.servlet.RequestScoper;
import com.google.inject.servlet.ServletScopes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.component.VEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.model.BaseModel;
import org.traccar.model.Calendar;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Report;
import org.traccar.model.User;
import org.traccar.reports.EventsReportProvider;
import org.traccar.reports.RouteReportProvider;
import org.traccar.reports.StopsReportProvider;
import org.traccar.reports.SummaryReportProvider;
import org.traccar.reports.TripsReportProvider;
import org.traccar.reports.common.ReportMailer;
import org.traccar.schedule.ScheduleTask;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class TaskReports
implements ScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskReports.class);
    private static final long CHECK_PERIOD_MINUTES = 1L;
    private final Storage storage;
    private final Injector injector;

    @Inject
    public TaskReports(Storage storage, Injector injector) {
        this.storage = storage;
        this.injector = injector;
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        executor.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        java.util.Date currentCheck = new java.util.Date();
        java.util.Date lastCheck = new java.util.Date(System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(1L));
        try {
            for (Report report : this.storage.getObjects(Report.class, new Request(new Columns.All()))) {
                Calendar calendar = this.storage.getObject(Calendar.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", report.getCalendarId())));
                Collection<VEvent> lastEvents = calendar.findEvents(lastCheck);
                Collection<VEvent> currentEvents = calendar.findEvents(currentCheck);
                if (lastEvents.isEmpty() || !currentEvents.isEmpty()) continue;
                VEvent event = lastEvents.iterator().next();
                Date from = event.getStartDate().getDate();
                Date to = event.getEndDate().getDate();
                RequestScoper scope = ServletScopes.scopeRequest(Collections.emptyMap());
                RequestScoper.CloseableScope ignored = scope.open();
                try {
                    this.executeReport(report, from, to);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Scheduled reports error", (Throwable)e);
        }
    }

    private void executeReport(Report report, java.util.Date from, java.util.Date to) throws StorageException {
        List deviceIds = this.storage.getObjects(Device.class, new Request((Columns)new Columns.Include("id"), new Condition.Permission(Device.class, Report.class, report.getId()))).stream().map(BaseModel::getId).collect(Collectors.toList());
        List groupIds = this.storage.getObjects(Group.class, new Request((Columns)new Columns.Include("id"), new Condition.Permission(Group.class, Report.class, report.getId()))).stream().map(BaseModel::getId).collect(Collectors.toList());
        List<User> users = this.storage.getObjects(User.class, new Request((Columns)new Columns.Include("id"), new Condition.Permission(User.class, Report.class, report.getId())));
        ReportMailer reportMailer = (ReportMailer)this.injector.getInstance(ReportMailer.class);
        block14: for (User user : users) {
            switch (report.getType()) {
                case "events": {
                    EventsReportProvider eventsReportProvider = (EventsReportProvider)this.injector.getInstance(EventsReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> eventsReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, List.of(), from, to));
                    continue block14;
                }
                case "route": {
                    RouteReportProvider routeReportProvider = (RouteReportProvider)this.injector.getInstance(RouteReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> routeReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to));
                    continue block14;
                }
                case "summary": {
                    SummaryReportProvider summaryReportProvider = (SummaryReportProvider)this.injector.getInstance(SummaryReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> summaryReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to, false));
                    continue block14;
                }
                case "trips": {
                    TripsReportProvider tripsReportProvider = (TripsReportProvider)this.injector.getInstance(TripsReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> tripsReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to));
                    continue block14;
                }
                case "stops": {
                    StopsReportProvider stopsReportProvider = (StopsReportProvider)this.injector.getInstance(StopsReportProvider.class);
                    reportMailer.sendAsync(user.getId(), stream -> stopsReportProvider.getExcel(stream, user.getId(), deviceIds, groupIds, from, to));
                    continue block14;
                }
            }
            LOGGER.warn("Unsupported report type {}", (Object)report.getType());
        }
    }
}

