/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.Map;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.config.Keys;
import org.traccar.helper.Checksum;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;

public class MeitrackProtocolEncoder
extends StringProtocolEncoder {
    public MeitrackProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private Object formatCommand(Command command, char dataId, String content) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        int length = 1 + uniqueId.length() + 1 + content.length() + 5;
        Object result = String.format("@@%c%02d,%s,%s*", Character.valueOf(dataId), length, uniqueId, content);
        result = (String)result + Checksum.sum((String)result) + "\r\n";
        return result;
    }

    @Override
    protected Object encodeCommand(Command command) {
        Map<String, Object> attributes = command.getAttributes();
        boolean alternative = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ALTERNATIVE.withPrefix(this.getProtocolName()), command.getDeviceId());
        switch (command.getType()) {
            case "positionSingle": {
                return this.formatCommand(command, 'Q', "A10");
            }
            case "engineStop": {
                return this.formatCommand(command, 'M', "C01,0,12222");
            }
            case "engineResume": {
                return this.formatCommand(command, 'M', "C01,0,02222");
            }
            case "alarmArm": {
                return this.formatCommand(command, 'M', alternative ? "B21,1" : "C01,0,22122");
            }
            case "alarmDisarm": {
                return this.formatCommand(command, 'M', alternative ? "B21,0" : "C01,0,22022");
            }
            case "requestPhoto": {
                int index = command.getInteger("index");
                return this.formatCommand(command, 'D', "D03," + (index > 0 ? index : 1) + ",camera_picture.jpg");
            }
            case "sendSms": {
                return this.formatCommand(command, 'f', "C02,0," + attributes.get("phone") + "," + attributes.get("message"));
            }
        }
        return null;
    }
}

