/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;

@Singleton
public class NotificatorTraccar
implements Notificator {
    private final NotificationFormatter notificationFormatter;
    private final Client client;
    private final String url;
    private final String key;

    @Inject
    public NotificatorTraccar(Config config, NotificationFormatter notificationFormatter, Client client) {
        this.notificationFormatter = notificationFormatter;
        this.client = client;
        this.url = "https://www.traccar.org/push/";
        this.key = config.getString(Keys.NOTIFICATOR_TRACCAR_KEY);
    }

    @Override
    public void send(User user, Event event, Position position) {
        if (user.hasAttribute("notificationTokens")) {
            NotificationMessage shortMessage = this.notificationFormatter.formatMessage(user, event, position, "short");
            Notification notification = new Notification();
            notification.title = shortMessage.getSubject();
            notification.body = shortMessage.getBody();
            notification.sound = "default";
            Message message = new Message();
            message.tokens = user.getString("notificationTokens").split("[, ]");
            message.notification = notification;
            this.client.target(this.url).request().header("Authorization", (Object)("key=" + this.key)).post(Entity.json((Object)message)).close();
        }
    }

    public static class Notification {
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="body")
        private String body;
        @JsonProperty(value="sound")
        private String sound;
    }

    public static class Message {
        @JsonProperty(value="registration_ids")
        private String[] tokens;
        @JsonProperty(value="notification")
        private Notification notification;
    }
}

