/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.traccar.config.Config;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.GeofenceUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Calendar;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Position;
import org.traccar.session.ConnectionManager;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
@ChannelHandler.Sharable
public class GeofenceEventHandler
extends BaseEventHandler {
    private final Config config;
    private final CacheManager cacheManager;
    private final ConnectionManager connectionManager;
    private final Storage storage;

    @Inject
    public GeofenceEventHandler(Config config, CacheManager cacheManager, ConnectionManager connectionManager, Storage storage) {
        this.config = config;
        this.cacheManager = cacheManager;
        this.connectionManager = connectionManager;
        this.storage = storage;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Event event;
        Calendar calendar;
        long calendarId;
        long geofenceId;
        Device device = this.cacheManager.getObject(Device.class, position.getDeviceId());
        if (device == null) {
            return null;
        }
        if (!PositionUtil.isLatest(this.cacheManager, position) || !position.getValid()) {
            return null;
        }
        List<Long> currentGeofences = GeofenceUtil.getCurrentGeofences(this.config, this.cacheManager, position);
        ArrayList<Long> oldGeofences = new ArrayList<Long>();
        if (device.getGeofenceIds() != null) {
            oldGeofences.addAll(device.getGeofenceIds());
        }
        ArrayList<Long> newGeofences = new ArrayList<Long>(currentGeofences);
        newGeofences.removeAll(oldGeofences);
        oldGeofences.removeAll(currentGeofences);
        if (!oldGeofences.isEmpty() || !newGeofences.isEmpty()) {
            device.setGeofenceIds(currentGeofences.isEmpty() ? null : currentGeofences);
            try {
                this.storage.updateObject(device, new Request((Columns)new Columns.Include("geofenceIds"), new Condition.Equals("id", device.getId())));
            }
            catch (StorageException e) {
                throw new RuntimeException("Update device geofences error", e);
            }
            this.connectionManager.updateDevice(true, device);
        }
        HashMap<Event, Position> events = new HashMap<Event, Position>();
        Iterator iterator = oldGeofences.iterator();
        while (iterator.hasNext()) {
            geofenceId = (Long)iterator.next();
            calendarId = this.cacheManager.getObject(Geofence.class, geofenceId).getCalendarId();
            Calendar calendar2 = calendar = calendarId != 0L ? this.cacheManager.getObject(Calendar.class, calendarId) : null;
            if (calendar != null && !calendar.checkMoment(position.getFixTime())) continue;
            event = new Event("geofenceExit", position);
            event.setGeofenceId(geofenceId);
            events.put(event, position);
        }
        iterator = newGeofences.iterator();
        while (iterator.hasNext()) {
            geofenceId = (Long)iterator.next();
            calendarId = this.cacheManager.getObject(Geofence.class, geofenceId).getCalendarId();
            Calendar calendar3 = calendar = calendarId != 0L ? this.cacheManager.getObject(Calendar.class, calendarId) : null;
            if (calendar != null && !calendar.checkMoment(position.getFixTime())) continue;
            event = new Event("geofenceEnter", position);
            event.setGeofenceId(geofenceId);
            events.put(event, position);
        }
        return events;
    }
}

