/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EsniKeyRecord;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParserFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EsniKeyRecordParser
extends Parser<EsniKeyRecord> {
    private static final Logger LOGGER = LogManager.getLogger();
    private EsniKeyRecord record;
    private Config config;

    public EsniKeyRecordParser(int startposition, byte[] array, Config config) {
        super(startposition, array);
        this.config = config;
    }

    @Override
    public EsniKeyRecord parse() {
        this.record = new EsniKeyRecord();
        this.parseVersion(this.record);
        this.parseChecksum(this.record);
        this.parseKeys(this.record);
        this.parseCipherSuites(this.record);
        this.parsePaddedLength(this.record);
        this.parseNotBefore(this.record);
        this.parseNotAfter(this.record);
        this.parseExtensions(this.record);
        return this.record;
    }

    private void parseVersion(EsniKeyRecord record) {
        byte[] version = this.parseByteArrayField(2);
        record.setVersion(EsniDnsKeyRecordVersion.getEnumByByte(version));
        LOGGER.debug("Version: " + (Object)((Object)record.getVersion()));
    }

    private void parseChecksum(EsniKeyRecord record) {
        byte[] checksum = this.parseByteArrayField(4);
        record.setChecksum(checksum);
        LOGGER.debug("Checksum: " + ArrayConverter.bytesToHexString((byte[])record.getChecksum()));
    }

    private void parseKeys(EsniKeyRecord record) {
        int keyExchangeLen;
        int keysLen = this.parseIntField(2);
        LOGGER.debug("KeysLength: " + keysLen);
        for (int i = 0; i < keysLen; i += 4 + keyExchangeLen) {
            byte[] namedGroup = this.parseByteArrayField(2);
            keyExchangeLen = this.parseIntField(2);
            byte[] keyExchange = this.parseByteArrayField(keyExchangeLen);
            KeyShareStoreEntry entry = new KeyShareStoreEntry();
            entry.setGroup(NamedGroup.getNamedGroup(namedGroup));
            entry.setPublicKey(keyExchange);
            record.getKeys().add(entry);
            LOGGER.debug("namedGroup: " + ArrayConverter.bytesToHexString((byte[])namedGroup));
            LOGGER.debug("keyExchange: " + ArrayConverter.bytesToHexString((byte[])keyExchange));
        }
    }

    private void parseCipherSuites(EsniKeyRecord record) {
        int cipherSuitesLen = this.parseIntField(2);
        byte[] cipherSuitesBytes = this.parseByteArrayField(cipherSuitesLen);
        List<CipherSuite> cipherSuites = CipherSuite.getCiphersuites(cipherSuitesBytes);
        record.setCipherSuiteList(cipherSuites);
    }

    private void parsePaddedLength(EsniKeyRecord record) {
        int paddedLength = this.parseIntField(2);
        record.setPaddedLength(paddedLength);
        LOGGER.debug("paddedLen: " + record.getPaddedLength());
    }

    private void parseNotBefore(EsniKeyRecord record) {
        byte[] notBefore = this.parseByteArrayField(8);
        record.setNotBefore(ArrayConverter.bytesToLong((byte[])notBefore));
        LOGGER.debug("notBefore: " + record.getNotBefore());
    }

    private void parseNotAfter(EsniKeyRecord record) {
        byte[] notAfter = this.parseByteArrayField(8);
        record.setNotAfter(ArrayConverter.bytesToLong((byte[])notAfter));
        LOGGER.debug("notAfter: " + record.getNotAfter());
    }

    private void parseExtensions(EsniKeyRecord record) {
        int extensionsLength = this.parseIntField(2);
        int i = 0;
        while (i < extensionsLength) {
            byte[] extensionType = this.parseByteArrayField(2);
            int contentLength = this.parseIntField(2);
            byte[] extensionContentBytes = this.parseByteArrayField(contentLength);
            ByteArrayOutputStream extensionStream = new ByteArrayOutputStream();
            try {
                extensionStream.write(extensionType);
                extensionStream.write(ArrayConverter.intToBytes((int)contentLength, (int)2));
                extensionStream.write(extensionContentBytes);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to parse extensions.");
            }
            byte[] extensionBytes = extensionStream.toByteArray();
            ExtensionParser parser = ExtensionParserFactory.getExtensionParser(extensionBytes, 0, HandshakeMessageType.UNKNOWN, this.config);
            Object extensionMessage = parser.parse();
            record.getExtensions().add((ExtensionMessage)extensionMessage);
            i = i + 2 + 2 + contentLength;
        }
    }
}

