/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.translator;

import de.rub.nds.asn1.translator.ContextComponent;

public abstract class Context {
    private final ContextComponent[] contextComponents;
    private int contextComponentPointer = 0;

    protected Context(ContextComponent[] contextComponents) {
        this.contextComponents = contextComponents;
    }

    public final boolean hasCurrent() {
        return this.contextComponentPointer < this.contextComponents.length;
    }

    public final boolean has(int offset) {
        return this.contextComponentPointer + offset < this.contextComponents.length;
    }

    public final ContextComponent getCurrent() {
        return this.contextComponents[this.contextComponentPointer];
    }

    public final ContextComponent peek(int offset) {
        return this.contextComponents[this.contextComponentPointer + offset];
    }

    public final void consume() {
        ++this.contextComponentPointer;
    }

    public final boolean canBeFinished() {
        boolean result = true;
        int offset = 0;
        while (this.contextComponentPointer + offset < this.contextComponents.length) {
            ContextComponent current = this.contextComponents[this.contextComponentPointer + offset];
            if (!current.isOptional && !current.isRepetitive) {
                result = false;
                break;
            }
            ++offset;
        }
        return result;
    }

    public abstract String getName();
}

