/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.stream.Field;

public class DateTimeFieldLenientImpl
extends AbstractField
implements DateTimeField {
    private static final String[] DEFAULT_DATE_FORMATS = new String[]{"EEE, dd MMM yy HH:mm:ss ZZZZ", "dd MMM yy HH:mm:ss ZZZZ", "EEE, dd MMM yy HH:mm:ss.SSS 0000", "EEE, dd MMM yy HH:mm:ss 0000", "EEE, dd MMM yyyy HH:mm:ss ZZZZ", "dd MMM yyyy HH:mm:ss ZZZZ", "EEE, dd MMM yyyy HH:mm:ss.SSS 0000", "EEE, dd MMM yyyy HH:mm:ss 0000", "EEE, dd MMM yy HH:mm:ss X", "dd MMM yy HH:mm:ss X", "EEE, dd MMM yy HH:mm:ss.SSS X", "EEE, dd MMM yy HH:mm:ss X", "EEE, dd MMM yyyy HH:mm:ss X", "dd MMM yyyy HH:mm:ss X", "EEE, dd MMM yyyy HH:mm:ss.SSS X", "EEE, dd MMM yyyy HH:mm:ss X"};
    private final List<String> datePatterns = Collections.unmodifiableList(Arrays.asList(DEFAULT_DATE_FORMATS));
    private boolean parsed = false;
    private Date date;
    public static final FieldParser<DateTimeField> PARSER = new FieldParser<DateTimeField>(){

        @Override
        public DateTimeField parse(Field rawField, DecodeMonitor monitor) {
            return new DateTimeFieldLenientImpl(rawField, monitor);
        }
    };

    private DateTimeFieldLenientImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    @Override
    public Date getDate() {
        if (!this.parsed) {
            this.parse();
        }
        return this.date;
    }

    private void parse() {
        this.parsed = true;
        this.date = null;
        String body = this.getBody();
        if (body != null) {
            body = body.trim();
        }
        for (String datePattern : this.datePatterns) {
            try {
                SimpleDateFormat parser = new SimpleDateFormat(datePattern, Locale.US);
                parser.setTimeZone(TimeZone.getTimeZone("GMT"));
                parser.setLenient(true);
                this.date = parser.parse(body);
                break;
            }
            catch (ParseException parseException) {
            }
        }
    }
}

