/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteBufferGuard;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

public abstract class ByteBufferIndexInput
extends IndexInput
implements RandomAccessInput {
    private static final FloatBuffer EMPTY_FLOATBUFFER = FloatBuffer.allocate(0);
    private static final LongBuffer EMPTY_LONGBUFFER = LongBuffer.allocate(0);
    private static final IntBuffer EMPTY_INTBUFFER = IntBuffer.allocate(0);
    protected final long length;
    protected final long chunkSizeMask;
    protected final int chunkSizePower;
    protected final ByteBufferGuard guard;
    protected ByteBuffer[] buffers;
    protected int curBufIndex = -1;
    protected ByteBuffer curBuf;
    private LongBuffer[] curLongBufferViews;
    private IntBuffer[] curIntBufferViews;
    private FloatBuffer[] curFloatBufferViews;
    protected boolean isClone = false;

    public static ByteBufferIndexInput newInstance(String resourceDescription, ByteBuffer[] buffers, long length, int chunkSizePower, ByteBufferGuard guard) {
        if (buffers.length == 1) {
            return new SingleBufferImpl(resourceDescription, buffers[0], length, chunkSizePower, guard);
        }
        return new MultiBufferImpl(resourceDescription, buffers, 0, length, chunkSizePower, guard);
    }

    ByteBufferIndexInput(String resourceDescription, ByteBuffer[] buffers, long length, int chunkSizePower, ByteBufferGuard guard) {
        super(resourceDescription);
        this.buffers = buffers;
        this.length = length;
        this.chunkSizePower = chunkSizePower;
        this.chunkSizeMask = (1L << chunkSizePower) - 1L;
        this.guard = guard;
        assert (chunkSizePower >= 0 && chunkSizePower <= 30);
        assert (length >>> chunkSizePower < Integer.MAX_VALUE);
    }

    protected void setCurBuf(ByteBuffer curBuf) {
        this.curBuf = curBuf;
        this.curLongBufferViews = null;
        this.curFloatBufferViews = null;
        this.curIntBufferViews = null;
    }

    @Override
    public final byte readByte() throws IOException {
        try {
            return this.guard.getByte(this.curBuf);
        }
        catch (BufferUnderflowException e) {
            do {
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.setCurBuf(this.buffers[this.curBufIndex]);
                this.curBuf.position(0);
            } while (!this.curBuf.hasRemaining());
            return this.guard.getByte(this.curBuf);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        try {
            this.guard.getBytes(this.curBuf, b, offset, len);
        }
        catch (BufferUnderflowException e) {
            int curAvail = this.curBuf.remaining();
            while (len > curAvail) {
                this.guard.getBytes(this.curBuf, b, offset, curAvail);
                len -= curAvail;
                offset += curAvail;
                ++this.curBufIndex;
                if (this.curBufIndex >= this.buffers.length) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.setCurBuf(this.buffers[this.curBufIndex]);
                this.curBuf.position(0);
                curAvail = this.curBuf.remaining();
            }
            this.guard.getBytes(this.curBuf, b, offset, len);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public void readLongs(long[] dst, int offset, int length) throws IOException {
        if (this.curLongBufferViews == null) {
            this.curLongBufferViews = new LongBuffer[8];
            for (int i = 0; i < 8; ++i) {
                this.curLongBufferViews[i] = i < this.curBuf.limit() ? this.curBuf.duplicate().position(i).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer() : EMPTY_LONGBUFFER;
            }
        }
        try {
            int position = this.curBuf.position();
            this.guard.getLongs(this.curLongBufferViews[position & 7].position(position >>> 3), dst, offset, length);
            this.curBuf.position(position + (length << 3));
        }
        catch (BufferUnderflowException e) {
            super.readLongs(dst, offset, length);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public void readInts(int[] dst, int offset, int length) throws IOException {
        if (this.curIntBufferViews == null) {
            this.curIntBufferViews = new IntBuffer[4];
            for (int i = 0; i < 4; ++i) {
                this.curIntBufferViews[i] = i < this.curBuf.limit() ? this.curBuf.duplicate().position(i).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer() : EMPTY_INTBUFFER;
            }
        }
        try {
            int position = this.curBuf.position();
            this.guard.getInts(this.curIntBufferViews[position & 3].position(position >>> 2), dst, offset, length);
            this.curBuf.position(position + (length << 2));
        }
        catch (BufferUnderflowException e) {
            super.readInts(dst, offset, length);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final void readFloats(float[] floats, int offset, int len) throws IOException {
        if (this.curFloatBufferViews == null) {
            this.curFloatBufferViews = new FloatBuffer[4];
            for (int i = 0; i < 4; ++i) {
                if (i < this.curBuf.limit()) {
                    ByteBuffer dup = this.curBuf.duplicate().order(ByteOrder.LITTLE_ENDIAN);
                    dup.position(i);
                    this.curFloatBufferViews[i] = dup.asFloatBuffer();
                    continue;
                }
                this.curFloatBufferViews[i] = EMPTY_FLOATBUFFER;
            }
        }
        try {
            int position = this.curBuf.position();
            FloatBuffer floatBuffer = this.curFloatBufferViews[position & 3];
            floatBuffer.position(position >>> 2);
            this.guard.getFloats(floatBuffer, floats, offset, len);
            this.curBuf.position(position + (len << 2));
        }
        catch (BufferUnderflowException e) {
            super.readFloats(floats, offset, len);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final short readShort() throws IOException {
        try {
            return this.guard.getShort(this.curBuf);
        }
        catch (BufferUnderflowException e) {
            return super.readShort();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final int readInt() throws IOException {
        try {
            return this.guard.getInt(this.curBuf);
        }
        catch (BufferUnderflowException e) {
            return super.readInt();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final long readLong() throws IOException {
        try {
            return this.guard.getLong(this.curBuf);
        }
        catch (BufferUnderflowException e) {
            return super.readLong();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public long getFilePointer() {
        try {
            return ((long)this.curBufIndex << this.chunkSizePower) + (long)this.curBuf.position();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            if (bi == this.curBufIndex) {
                this.curBuf.position((int)(pos & this.chunkSizeMask));
            } else {
                ByteBuffer b = this.buffers[bi];
                b.position((int)(pos & this.chunkSizeMask));
                this.curBufIndex = bi;
                this.setCurBuf(b);
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public byte readByte(long pos) throws IOException {
        try {
            int bi = (int)(pos >> this.chunkSizePower);
            return this.guard.getByte(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    private void setPos(long pos, int bi) throws IOException {
        try {
            ByteBuffer b = this.buffers[bi];
            b.position((int)(pos & this.chunkSizeMask));
            this.curBufIndex = bi;
            this.setCurBuf(b);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException aioobe) {
            throw new EOFException("seek past EOF: " + this);
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public short readShort(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            return this.guard.getShort(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, bi);
            return this.readShort();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public int readInt(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            return this.guard.getInt(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, bi);
            return this.readInt();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public long readLong(long pos) throws IOException {
        int bi = (int)(pos >> this.chunkSizePower);
        try {
            return this.guard.getLong(this.buffers[bi], (int)(pos & this.chunkSizeMask));
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, bi);
            return this.readLong();
        }
        catch (NullPointerException npe) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
    }

    @Override
    public final long length() {
        return this.length;
    }

    @Override
    public final ByteBufferIndexInput clone() {
        ByteBufferIndexInput clone = this.buildSlice((String)null, 0L, this.length);
        try {
            clone.seek(this.getFilePointer());
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        return clone;
    }

    @Override
    public final ByteBufferIndexInput slice(String sliceDescription, long offset, long length) {
        if (offset < 0L || length < 0L || offset + length > this.length) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + this);
        }
        return this.buildSlice(sliceDescription, offset, length);
    }

    protected ByteBufferIndexInput buildSlice(String sliceDescription, long offset, long length) {
        if (this.buffers == null) {
            throw new AlreadyClosedException("Already closed: " + this);
        }
        ByteBuffer[] newBuffers = this.buildSlice(this.buffers, offset, length);
        int ofs = (int)(offset & this.chunkSizeMask);
        ByteBufferIndexInput clone = this.newCloneInstance(this.getFullSliceDescription(sliceDescription), newBuffers, ofs, length);
        clone.isClone = true;
        return clone;
    }

    protected ByteBufferIndexInput newCloneInstance(String newResourceDescription, ByteBuffer[] newBuffers, int offset, long length) {
        if (newBuffers.length == 1) {
            newBuffers[0].position(offset);
            return new SingleBufferImpl(newResourceDescription, newBuffers[0].slice().order(ByteOrder.LITTLE_ENDIAN), length, this.chunkSizePower, this.guard);
        }
        return new MultiBufferImpl(newResourceDescription, newBuffers, offset, length, this.chunkSizePower, this.guard);
    }

    private ByteBuffer[] buildSlice(ByteBuffer[] buffers, long offset, long length) {
        long sliceEnd = offset + length;
        int startIndex = (int)(offset >>> this.chunkSizePower);
        int endIndex = (int)(sliceEnd >>> this.chunkSizePower);
        ByteBuffer[] slices = new ByteBuffer[endIndex - startIndex + 1];
        for (int i = 0; i < slices.length; ++i) {
            slices[i] = buffers[startIndex + i].duplicate().order(ByteOrder.LITTLE_ENDIAN);
        }
        slices[slices.length - 1].limit((int)(sliceEnd & this.chunkSizeMask));
        return slices;
    }

    @Override
    public final void close() throws IOException {
        try {
            if (this.buffers == null) {
                return;
            }
            ByteBuffer[] bufs = this.buffers;
            this.unsetBuffers();
            if (this.isClone) {
                return;
            }
            this.guard.invalidateAndUnmap(bufs);
        }
        finally {
            this.unsetBuffers();
        }
    }

    private void unsetBuffers() {
        this.buffers = null;
        this.curBuf = null;
        this.curBufIndex = 0;
        this.curLongBufferViews = null;
        this.curIntBufferViews = null;
    }

    static final class MultiBufferImpl
    extends ByteBufferIndexInput {
        private final int offset;

        MultiBufferImpl(String resourceDescription, ByteBuffer[] buffers, int offset, long length, int chunkSizePower, ByteBufferGuard guard) {
            super(resourceDescription, buffers, length, chunkSizePower, guard);
            this.offset = offset;
            try {
                this.seek(0L);
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }

        @Override
        public void seek(long pos) throws IOException {
            assert (pos >= 0L);
            super.seek(pos + (long)this.offset);
        }

        @Override
        public long getFilePointer() {
            return super.getFilePointer() - (long)this.offset;
        }

        @Override
        public byte readByte(long pos) throws IOException {
            return super.readByte(pos + (long)this.offset);
        }

        @Override
        public short readShort(long pos) throws IOException {
            return super.readShort(pos + (long)this.offset);
        }

        @Override
        public int readInt(long pos) throws IOException {
            return super.readInt(pos + (long)this.offset);
        }

        @Override
        public long readLong(long pos) throws IOException {
            return super.readLong(pos + (long)this.offset);
        }

        @Override
        protected ByteBufferIndexInput buildSlice(String sliceDescription, long ofs, long length) {
            return super.buildSlice(sliceDescription, (long)this.offset + ofs, length);
        }
    }

    static final class SingleBufferImpl
    extends ByteBufferIndexInput {
        SingleBufferImpl(String resourceDescription, ByteBuffer buffer, long length, int chunkSizePower, ByteBufferGuard guard) {
            super(resourceDescription, new ByteBuffer[]{buffer}, length, chunkSizePower, guard);
            this.curBufIndex = 0;
            assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
            this.setCurBuf(buffer);
            buffer.position(0);
        }

        @Override
        public void seek(long pos) throws IOException {
            try {
                this.curBuf.position((int)pos);
            }
            catch (IllegalArgumentException e) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public long getFilePointer() {
            try {
                return this.curBuf.position();
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public byte readByte(long pos) throws IOException {
            try {
                return this.guard.getByte(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public short readShort(long pos) throws IOException {
            try {
                return this.guard.getShort(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public int readInt(long pos) throws IOException {
            try {
                return this.guard.getInt(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }

        @Override
        public long readLong(long pos) throws IOException {
            try {
                return this.guard.getLong(this.curBuf, (int)pos);
            }
            catch (IllegalArgumentException e) {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this, e);
                }
                throw new EOFException("seek past EOF: " + this);
            }
            catch (NullPointerException npe) {
                throw new AlreadyClosedException("Already closed: " + this);
            }
        }
    }
}

