/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelJsonWriter
implements RelWriter {
    protected final JsonBuilder jsonBuilder;
    protected final RelJson relJson;
    private final IdentityHashMap<RelNode, String> relIdMap = new IdentityHashMap();
    protected final List<@Nullable Object> relList;
    private final List<Pair<String, @Nullable Object>> values = new ArrayList<Pair<String, Object>>();
    private @Nullable String previousId;

    public RelJsonWriter() {
        this(new JsonBuilder());
    }

    public RelJsonWriter(JsonBuilder jsonBuilder) {
        this.jsonBuilder = jsonBuilder;
        this.relList = this.jsonBuilder.list();
        this.relJson = new RelJson(this.jsonBuilder);
    }

    protected void explain_(RelNode rel, List<Pair<String, @Nullable Object>> values) {
        Map<String, @Nullable Object> map = this.jsonBuilder.map();
        map.put("id", null);
        map.put("relOp", this.relJson.classToTypeName(rel.getClass()));
        for (Pair<String, Object> value : values) {
            if (value.right instanceof RelNode) continue;
            this.put(map, (String)value.left, value.right);
        }
        List<@Nullable Object> list = this.explainInputs(rel.getInputs());
        if (list.size() != 1 || !Objects.equals(list.get(0), this.previousId)) {
            map.put("inputs", list);
        }
        String id = Integer.toString(this.relIdMap.size());
        this.relIdMap.put(rel, id);
        map.put("id", id);
        this.relList.add(map);
        this.previousId = id;
    }

    private void put(Map<String, @Nullable Object> map, String name, @Nullable Object value) {
        map.put(name, this.relJson.toJson(value));
    }

    private List<@Nullable Object> explainInputs(List<RelNode> inputs) {
        List<@Nullable Object> list = this.jsonBuilder.list();
        for (RelNode input : inputs) {
            String id = this.relIdMap.get(input);
            if (id == null) {
                input.explain(this);
                id = this.previousId;
            }
            list.add(id);
        }
        return list;
    }

    @Override
    public final void explain(RelNode rel, List<Pair<String, @Nullable Object>> valueList) {
        this.explain_(rel, valueList);
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return SqlExplainLevel.ALL_ATTRIBUTES;
    }

    @Override
    public RelWriter item(String term, @Nullable Object value) {
        this.values.add(Pair.of(term, value));
        return this;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public RelWriter done(RelNode node) {
        @Nullable ImmutableList valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain_(node, (List<Pair<String, Object>>)valuesCopy);
        return this;
    }

    @Override
    public boolean nest() {
        return true;
    }

    public String asString() {
        Map<String, @Nullable Object> map = this.jsonBuilder.map();
        map.put("rels", this.relList);
        return this.jsonBuilder.toJsonString(map);
    }
}

