/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.StreamingBinaryResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.SolrCLI;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class ExportTool
extends SolrCLI.ToolBase {
    static Set<String> formats = ImmutableSet.of((Object)"javabin", (Object)"jsonl");
    private static final Option[] OPTIONS = new Option[]{Option.builder((String)"url").hasArg().required().desc("Address of the collection, example http://localhost:8983/solr/gettingstarted.").build(), Option.builder((String)"out").hasArg().required(false).desc("File name, defaults to 'collection-name.<format>'.").build(), Option.builder((String)"format").hasArg().required(false).desc("Output format for exported docs (json or javabin), defaulting to json. File extension would be .json.").build(), Option.builder((String)"limit").hasArg().required(false).desc("Maximum number of docs to download. Default is 100, use -1 for all docs.").build(), Option.builder((String)"query").hasArg().required(false).desc("A custom query, default is '*:*'.").build(), Option.builder((String)"fields").hasArg().required(false).desc("Comma separated list of fields to export. By default all fields are fetched.").build()};

    @Override
    public String getName() {
        return "export";
    }

    @Override
    public Option[] getOptions() {
        return OPTIONS;
    }

    @Override
    protected void runImpl(CommandLine cli) throws Exception {
        String url = cli.getOptionValue("url");
        MultiThreadedRunner info = new MultiThreadedRunner(url);
        info.query = cli.getOptionValue("query", "*:*");
        info.setOutFormat(cli.getOptionValue("out"), cli.getOptionValue("format"));
        info.fields = cli.getOptionValue("fields");
        info.setLimit(cli.getOptionValue("limit", "100"));
        info.output = this.stdout;
        ((Info)info).exportDocs();
    }

    static long getDocCount(String coreName, HttpSolrClient client) throws SolrServerException, IOException {
        SolrQuery q = new SolrQuery("*:*");
        q.setRows(Integer.valueOf(0));
        q.add("distrib", new String[]{"false"});
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, "/" + coreName + "/select", (SolrParams)q);
        NamedList res = client.request((SolrRequest)request);
        SolrDocumentList sdl = (SolrDocumentList)res.get("response");
        return sdl.getNumFound();
    }

    static class MultiThreadedRunner
    extends Info {
        ExecutorService producerThreadpool;
        ExecutorService consumerThreadpool;
        ArrayBlockingQueue<SolrDocument> queue = new ArrayBlockingQueue(1000);
        SolrDocument EOFDOC = new SolrDocument();
        volatile boolean failed = false;
        Map<String, CoreHandler> corehandlers = new HashMap<String, CoreHandler>();
        private long startTime = System.currentTimeMillis();

        @SuppressForbidden(reason="Need to print out time")
        public MultiThreadedRunner(String url) {
            super(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressForbidden(reason="Need to print out time")
        void exportDocs() throws Exception {
            this.sink = this.getSink();
            this.fetchUniqueKey();
            ClusterStateProvider stateProvider = this.solrClient.getClusterStateProvider();
            DocCollection coll = stateProvider.getCollection(this.coll);
            Map m = coll.getSlicesMap();
            this.producerThreadpool = ExecutorUtil.newMDCAwareFixedThreadPool((int)m.size(), (ThreadFactory)new SolrNamedThreadFactory("solrcli-exporter-producers"));
            this.consumerThreadpool = ExecutorUtil.newMDCAwareFixedThreadPool((int)1, (ThreadFactory)new SolrNamedThreadFactory("solrcli-exporter-consumer"));
            this.sink.start();
            CountDownLatch consumerlatch = new CountDownLatch(1);
            try {
                this.addConsumer(consumerlatch);
                this.addProducers(m);
                if (this.output != null) {
                    this.output.println("NO: of shards : " + this.corehandlers.size());
                }
                CountDownLatch producerLatch = new CountDownLatch(this.corehandlers.size());
                this.corehandlers.forEach((s, coreHandler) -> this.producerThreadpool.submit(() -> {
                    block2: {
                        try {
                            coreHandler.exportDocsFromCore();
                        }
                        catch (Exception e) {
                            if (this.output == null) break block2;
                            this.output.println("Error exporting docs from : " + s);
                        }
                    }
                    producerLatch.countDown();
                }));
                producerLatch.await();
                this.queue.offer(this.EOFDOC, 10L, TimeUnit.SECONDS);
                consumerlatch.await();
            }
            finally {
                this.sink.end();
                this.solrClient.close();
                this.producerThreadpool.shutdownNow();
                this.consumerThreadpool.shutdownNow();
                if (this.failed) {
                    try {
                        Files.delete(new File(this.out).toPath());
                    }
                    catch (IOException iOException) {}
                }
                System.out.println("\nTotal Docs exported: " + (this.docsWritten.get() - 1L) + ". Time taken: " + (System.currentTimeMillis() - this.startTime) / 1000L + "secs");
            }
        }

        private void addProducers(Map<String, Slice> m) {
            for (Map.Entry<String, Slice> entry : m.entrySet()) {
                Slice slice = entry.getValue();
                Replica replica = slice.getLeader();
                if (replica == null) {
                    replica = (Replica)slice.getReplicas().iterator().next();
                }
                CoreHandler coreHandler = new CoreHandler(replica);
                this.corehandlers.put(replica.getCoreName(), coreHandler);
            }
        }

        private void addConsumer(CountDownLatch consumerlatch) {
            this.consumerThreadpool.submit(() -> {
                while (true) {
                    SolrDocument doc = null;
                    try {
                        doc = this.queue.poll(30L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        if (this.output != null) {
                            this.output.println("Consumer interrupted");
                        }
                        this.failed = true;
                        break;
                    }
                    if (doc == this.EOFDOC) break;
                    try {
                        if (this.docsWritten.get() > this.limit) continue;
                        this.sink.accept(doc);
                    }
                    catch (Exception e) {
                        if (this.output != null) {
                            this.output.println("Failed to write to file " + e.getMessage());
                        }
                        this.failed = true;
                    }
                }
                consumerlatch.countDown();
            });
        }

        class CoreHandler {
            final Replica replica;
            long expectedDocs;
            AtomicLong receivedDocs = new AtomicLong();

            CoreHandler(Replica replica) {
                this.replica = replica;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            boolean exportDocsFromCore() throws IOException, SolrServerException {
                try (HttpSolrClient client = new HttpSolrClient.Builder(MultiThreadedRunner.this.baseurl).build();){
                    this.expectedDocs = ExportTool.getDocCount(this.replica.getCoreName(), client);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.add("q", new String[]{MultiThreadedRunner.this.query});
                    if (MultiThreadedRunner.this.fields != null) {
                        params.add("fl", new String[]{MultiThreadedRunner.this.fields});
                    }
                    params.add("sort", new String[]{MultiThreadedRunner.this.uniqueKey + " asc"});
                    params.add("distrib", new String[]{"false"});
                    params.add("rows", new String[]{"1000"});
                    String cursorMark = "*";
                    Consumer<SolrDocument> wrapper = doc -> {
                        block2: {
                            try {
                                MultiThreadedRunner.this.queue.offer((SolrDocument)doc, 10L, TimeUnit.SECONDS);
                                this.receivedDocs.incrementAndGet();
                            }
                            catch (InterruptedException e) {
                                MultiThreadedRunner.this.failed = true;
                                if (MultiThreadedRunner.this.output == null) break block2;
                                MultiThreadedRunner.this.output.println("Failed to write docs from" + e.getMessage());
                            }
                        }
                    };
                    StreamingBinaryResponseParser responseParser = new StreamingBinaryResponseParser(Info.getStreamer(wrapper));
                    while (true) {
                        String nextCursorMark;
                        if (MultiThreadedRunner.this.failed) {
                            boolean bl = false;
                            return bl;
                        }
                        if (MultiThreadedRunner.this.docsWritten.get() > MultiThreadedRunner.this.limit) {
                            boolean bl = true;
                            return bl;
                        }
                        params.set("cursorMark", new String[]{cursorMark});
                        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, "/" + this.replica.getCoreName() + "/select", (SolrParams)params);
                        request.setResponseParser((ResponseParser)responseParser);
                        try {
                            NamedList rsp = client.request((SolrRequest)request);
                            nextCursorMark = (String)rsp.get("nextCursorMark");
                            if (nextCursorMark == null || Objects.equals(cursorMark, nextCursorMark)) {
                                if (MultiThreadedRunner.this.output != null) {
                                    MultiThreadedRunner.this.output.println(StrUtils.formatString((String)"\nExport complete for : {0}, docs : {1}", (Object[])new Object[]{this.replica.getCoreName(), this.receivedDocs.get()}));
                                }
                                if (this.expectedDocs != this.receivedDocs.get() && MultiThreadedRunner.this.output != null) {
                                    MultiThreadedRunner.this.output.println(StrUtils.formatString((String)"Could not download all docs for core {0} , expected: {1} , actual", (Object[])new Object[]{this.replica.getCoreName(), this.expectedDocs, this.receivedDocs}));
                                    boolean bl = false;
                                    return bl;
                                }
                                boolean bl = true;
                                return bl;
                            }
                        }
                        catch (SolrServerException e) {
                            if (MultiThreadedRunner.this.output != null) {
                                MultiThreadedRunner.this.output.println("Error reading from server " + this.replica.getBaseUrl() + "/" + this.replica.getCoreName());
                            }
                            MultiThreadedRunner.this.failed = true;
                            boolean bl = false;
                            return bl;
                        }
                        {
                            cursorMark = nextCursorMark;
                            if (MultiThreadedRunner.this.output == null) continue;
                            MultiThreadedRunner.this.output.print(".");
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    static class JavabinSink
    extends DocsSink {
        JavaBinCodec codec;
        private BiConsumer<String, Object> bic = new BiConsumer<String, Object>(){

            @Override
            public void accept(String s, Object o) {
                try {
                    if (s.equals("_version_") || s.equals("_root_")) {
                        return;
                    }
                    codec.writeExternString((CharSequence)s);
                    codec.writeVal(o);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        public JavabinSink(Info info) {
            this.info = info;
        }

        @Override
        public void start() throws IOException {
            this.fos = new FileOutputStream(this.info.out);
            if (this.info.out.endsWith(".json.gz") || this.info.out.endsWith(".json.")) {
                this.fos = new GZIPOutputStream(this.fos);
            }
            if (this.info.bufferSize > 0) {
                this.fos = new BufferedOutputStream(this.fos, this.info.bufferSize);
            }
            this.codec = new JavaBinCodec(this.fos, null);
            this.codec.writeTag((byte)-64, 2);
            this.codec.writeStr((CharSequence)"params");
            this.codec.writeNamedList(new NamedList());
            this.codec.writeStr((CharSequence)"docs");
            this.codec.writeTag((byte)14);
        }

        @Override
        public void end() throws IOException {
            this.codec.writeTag((byte)15);
            this.codec.close();
            this.fos.flush();
            this.fos.close();
        }

        @Override
        public synchronized void accept(SolrDocument doc) throws IOException {
            int sz = doc.size();
            if (doc.containsKey((Object)"_version_")) {
                --sz;
            }
            if (doc.containsKey((Object)"_root_")) {
                --sz;
            }
            this.codec.writeTag((byte)16, sz);
            this.codec.writeFloat(1.0f);
            doc.forEach(this.bic);
            super.accept(doc);
        }
    }

    static class JsonSink
    extends DocsSink {
        private CharArr charArr = new CharArr(2048);
        JSONWriter jsonWriter = new JSONWriter(this.charArr, -1);
        private Writer writer;

        public JsonSink(Info info) {
            this.info = info;
        }

        @Override
        public void start() throws IOException {
            this.fos = new FileOutputStream(this.info.out);
            if (this.info.out.endsWith(".json.gz") || this.info.out.endsWith(".json.")) {
                this.fos = new GZIPOutputStream(this.fos);
            }
            if (this.info.bufferSize > 0) {
                this.fos = new BufferedOutputStream(this.fos, this.info.bufferSize);
            }
            this.writer = new OutputStreamWriter(this.fos, StandardCharsets.UTF_8);
        }

        @Override
        public void end() throws IOException {
            this.writer.flush();
            this.fos.flush();
            this.fos.close();
        }

        @Override
        public synchronized void accept(SolrDocument doc) throws IOException {
            this.charArr.reset();
            LinkedHashMap m = new LinkedHashMap(doc.size());
            doc.forEach((s, field) -> {
                List list;
                if (s.equals("_version_") || s.equals("_roor_")) {
                    return;
                }
                if (field instanceof List && ((List)field).size() == 1) {
                    field = ((List)field).get(0);
                }
                if ((field = this.constructDateStr(field)) instanceof List && this.hasdate(list = (List)field)) {
                    ArrayList<Object> listCopy = new ArrayList<Object>(list.size());
                    for (Object o : list) {
                        listCopy.add(this.constructDateStr(o));
                    }
                    field = listCopy;
                }
                m.put(s, field);
            });
            this.jsonWriter.write(m);
            this.writer.write(this.charArr.getArray(), this.charArr.getStart(), this.charArr.getEnd());
            this.writer.append('\n');
            super.accept(doc);
        }

        private boolean hasdate(List<?> list) {
            boolean hasDate = false;
            for (Object o : list) {
                if (!(o instanceof Date)) continue;
                hasDate = true;
                break;
            }
            return hasDate;
        }

        private Object constructDateStr(Object field) {
            if (field instanceof Date) {
                field = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(((Date)field).getTime()));
            }
            return field;
        }
    }

    static abstract class DocsSink {
        Info info;
        OutputStream fos;

        DocsSink() {
        }

        abstract void start() throws IOException;

        @SuppressForbidden(reason="Command line tool prints out to console")
        void accept(SolrDocument document) throws IOException {
            long count = this.info.docsWritten.incrementAndGet();
            if (count % 100000L == 0L) {
                System.out.println("\nDOCS: " + count);
            }
        }

        void end() throws IOException {
        }
    }

    public static abstract class Info {
        String baseurl;
        String format;
        String query;
        String coll;
        String out;
        String fields;
        long limit = 100L;
        AtomicLong docsWritten = new AtomicLong(0L);
        int bufferSize = 0x100000;
        PrintStream output;
        String uniqueKey;
        CloudSolrClient solrClient;
        DocsSink sink;

        public Info(String url) {
            this.setUrl(url);
            this.setOutFormat(null, "jsonl");
        }

        public void setUrl(String url) {
            int idx = url.lastIndexOf(47);
            this.baseurl = url.substring(0, idx);
            this.coll = url.substring(idx + 1);
            this.query = "*:*";
        }

        public void setLimit(String maxDocsStr) {
            this.limit = Long.parseLong(maxDocsStr);
            if (this.limit == -1L) {
                this.limit = Long.MAX_VALUE;
            }
        }

        public void setOutFormat(String out, String format) {
            this.format = format;
            if (format == null) {
                format = "jsonl";
            }
            if (!formats.contains(format)) {
                throw new IllegalArgumentException("format must be one of :" + formats);
            }
            this.out = out;
            if (this.out == null) {
                this.out = "javabin".equals(format) ? this.coll + ".javabin" : this.coll + ".json";
            }
        }

        DocsSink getSink() {
            return "javabin".equals(this.format) ? new JavabinSink(this) : new JsonSink(this);
        }

        abstract void exportDocs() throws Exception;

        void fetchUniqueKey() throws SolrServerException, IOException {
            this.solrClient = new CloudLegacySolrClient.Builder(Collections.singletonList(this.baseurl)).build();
            NamedList response = this.solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/schema/uniquekey", (SolrParams)new MapSolrParams(Collections.singletonMap("collection", this.coll))));
            this.uniqueKey = (String)response.get("uniqueKey");
        }

        public static StreamingResponseCallback getStreamer(final Consumer<SolrDocument> sink) {
            return new StreamingResponseCallback(){

                public void streamSolrDocument(SolrDocument doc) {
                    try {
                        sink.accept(doc);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void streamDocListInfo(long numFound, long start, Float maxScore) {
                }
            };
        }
    }
}

