/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.solr.core.RateLimiterConfig;

public class RequestRateLimiter {
    private final Semaphore guaranteedSlotsPool;
    private final Semaphore borrowableSlotsPool;
    private final RateLimiterConfig rateLimiterConfig;
    private final SlotMetadata guaranteedSlotMetadata;
    private final SlotMetadata borrowedSlotMetadata;
    private static final SlotMetadata nullSlotMetadata = new SlotMetadata(null);

    public RequestRateLimiter(RateLimiterConfig rateLimiterConfig) {
        this.rateLimiterConfig = rateLimiterConfig;
        this.guaranteedSlotsPool = new Semaphore(rateLimiterConfig.guaranteedSlotsThreshold);
        this.borrowableSlotsPool = new Semaphore(rateLimiterConfig.allowedRequests - rateLimiterConfig.guaranteedSlotsThreshold);
        this.guaranteedSlotMetadata = new SlotMetadata(this.guaranteedSlotsPool);
        this.borrowedSlotMetadata = new SlotMetadata(this.borrowableSlotsPool);
    }

    public SlotMetadata handleRequest() throws InterruptedException {
        if (!this.rateLimiterConfig.isEnabled) {
            return nullSlotMetadata;
        }
        if (this.guaranteedSlotsPool.tryAcquire(this.rateLimiterConfig.waitForSlotAcquisition, TimeUnit.MILLISECONDS)) {
            return this.guaranteedSlotMetadata;
        }
        if (this.borrowableSlotsPool.tryAcquire(this.rateLimiterConfig.waitForSlotAcquisition, TimeUnit.MILLISECONDS)) {
            return this.borrowedSlotMetadata;
        }
        return null;
    }

    public SlotMetadata allowSlotBorrowing() throws InterruptedException {
        if (this.borrowableSlotsPool.tryAcquire(this.rateLimiterConfig.waitForSlotAcquisition, TimeUnit.MILLISECONDS)) {
            return this.borrowedSlotMetadata;
        }
        return nullSlotMetadata;
    }

    public RateLimiterConfig getRateLimiterConfig() {
        return this.rateLimiterConfig;
    }

    static class SlotMetadata {
        private final Semaphore usedPool;

        public SlotMetadata(Semaphore usedPool) {
            this.usedPool = usedPool;
        }

        public void decrementRequest() {
            if (this.usedPool != null) {
                this.usedPool.release();
            }
        }

        public boolean isReleasable() {
            return this.usedPool != null;
        }
    }
}

