/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.BalanceShardUniquePayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class BalanceShardUniqueAPI {
    private static final String V2_BALANCE_SHARD_UNIQUE_CMD = "balance-shard-unique";
    private final CollectionsHandler collectionsHandler;

    public BalanceShardUniqueAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="balance-shard-unique")
    public void balanceShardUnique(PayloadObj<BalanceShardUniquePayload> obj) throws Exception {
        BalanceShardUniquePayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

