/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.AddReplicaPropertyPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class AddReplicaPropertyAPI {
    private static final String V2_ADD_REPLICA_PROPERTY_CMD = "add-replica-property";
    private final CollectionsHandler collectionsHandler;

    public AddReplicaPropertyAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="add-replica-property")
    public void addReplicaProperty(PayloadObj<AddReplicaPropertyPayload> obj) throws Exception {
        AddReplicaPropertyPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        v1Params.put("property", v1Params.remove("name"));
        v1Params.put("property.value", v1Params.remove("value"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

