/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.distribution.Format;

public abstract class DocumentedStoreProvider
extends URIDataStore.Provider {
    private final String name;
    private transient Format format;

    protected DocumentedStoreProvider(String string) {
        this.name = string;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public final Format getFormat() {
        return this.getFormat(null);
    }

    public final synchronized Format getFormat(StoreListeners storeListeners) {
        if (this.format == null) {
            if (this.name != null) {
                try {
                    this.format = (Format)MetadataSource.getProvided().lookup(Format.class, this.name);
                    return this.format;
                }
                catch (MetadataStoreException metadataStoreException) {
                    LogRecord logRecord = Resources.forLocale(null).getLogRecord(Level.WARNING, (short)39, this.getShortName(), metadataStoreException.getLocalizedMessage());
                    logRecord.setSourceClassName(this.getClass().getCanonicalName());
                    logRecord.setSourceMethodName("getFormat");
                    logRecord.setLoggerName("org.apache.sis.storage");
                    if (storeListeners != null) {
                        storeListeners.warning(logRecord);
                    }
                    Logging.getLogger("org.apache.sis.storage").log(logRecord);
                }
            }
            this.format = super.getFormat();
        }
        return this.format;
    }
}

