/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.dialog.AbstractDialog;
import com.projectlibre1.menu.MenuManager;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.preference.ConfigurationFile;
import com.projectlibre1.strings.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.commons.lang.StringEscapeUtils;

public final class LocaleDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    JComboBox<String> languageCombo;
    JComboBox<Country> countryCombo;
    JCheckBox externalCheckbox = new JCheckBox(Messages.getString("Text.ExternalLocaleUse"));
    JTextField directoryField = new JTextField();
    JButton directorySetButton = new JButton(Messages.getString("Text.ExternalLocaleDirectorySet"));
    JButton directoryUpdateButton = new JButton(Messages.getString("Text.ExternalLocaleDirectoryUpdate"));
    JButton directoryExportButton = new JButton(Messages.getString("Text.ExternalLocaleDirectoryExport"));
    JTextPane messageArea;
    JTable externalList;
    AbstractTableModel externalListModel;
    String[] externalListColumns = new String[]{"code", "client.properties", "menu.properties"};
    ArrayList<LanguageProperties> files = new ArrayList();
    String[] slocales = Settings.LANGUAGES.split(";");
    Set<String> allLocales = new TreeSet<String>();
    Map<String, String> transOri = new HashMap<String, String>();
    Map<String, String> oriTrans = new HashMap<String, String>();
    public static final Country DEFAULT_COUNTRY = new Country();

    @Override
    protected boolean bind(boolean bl) {
        Preferences preferences = Preferences.userNodeForPackage(ConfigurationFile.class);
        if (bl) {
            this.updateLocales(true);
            boolean bl2 = preferences.getBoolean("useExternalLocales", false);
            this.externalCheckbox.setSelected(bl2);
            this.directoryField.setEnabled(bl2);
            this.directorySetButton.setEnabled(bl2);
            this.directoryUpdateButton.setEnabled(bl2);
            this.directoryExportButton.setEnabled(bl2);
            this.directoryField.setText(preferences.get("externalLocalesDirectory", ""));
        } else {
            String string;
            String string2 = (String)this.languageCombo.getSelectedItem();
            String string3 = ((Country)this.countryCombo.getSelectedItem()).getCode();
            String string4 = this.transOri.get(string2);
            String string5 = string = string4 == null ? string2 : string4;
            if (!"".equals(string3)) {
                string = string + "_" + string3;
            }
            preferences.put("locale", string);
            preferences.putBoolean("useExternalLocales", this.externalCheckbox.isSelected());
            preferences.put("externalLocalesDirectory", this.directoryField.getText());
        }
        return true;
    }

    public void updateLocales(boolean bl) {
        String string;
        Object object;
        String[] stringArray;
        Object object2;
        Country country;
        String string2;
        String string3 = Preferences.userNodeForPackage(ConfigurationFile.class).get("locale", "default");
        if ("default".equals(string3)) {
            string2 = string3;
            country = DEFAULT_COUNTRY;
        } else {
            object2 = ConfigurationFile.getLocaleCodes(string3);
            string2 = object2[0];
            stringArray = object2[1];
            if (stringArray == null || "".equals(stringArray)) {
                country = DEFAULT_COUNTRY;
            } else {
                object = new Locale("en", (String)stringArray);
                country = new Country((String)stringArray, ((Locale)object).getDisplayCountry((Locale)object));
            }
        }
        if (bl) {
            object2 = new TreeSet();
            ((TreeSet)object2).add(DEFAULT_COUNTRY);
            stringArray = Locale.getISOCountries();
            for (String string4 : stringArray) {
                Locale object3 = new Locale("en", string4);
                ((TreeSet)object2).add(new Country(string4, object3.getDisplayCountry(object3)));
            }
            object = ((TreeSet)object2).iterator();
            while (object.hasNext()) {
                Country country2 = (Country)object.next();
                this.countryCombo.addItem(country2);
            }
            this.countryCombo.setSelectedItem(country);
        }
        for (String string5 : this.slocales) {
            String string6 = "default".equals(string5) ? Messages.getString("Text.DefaultLocale") : string5;
            this.oriTrans.put(string5, string6);
            this.transOri.put(string6, string5);
        }
        object2 = bl ? ((string = this.oriTrans.get(string2)) == null ? string2 : string) : (String)this.languageCombo.getSelectedItem();
        this.allLocales.clear();
        this.languageCombo.removeAllItems();
        for (LanguageProperties languageProperties : this.files) {
            if (languageProperties.getClientStatus() != FileStatus.OK && languageProperties.getMenuStatus() != FileStatus.OK) continue;
            this.allLocales.add(languageProperties.code);
        }
        boolean bl2 = false;
        String object4 = null;
        for (String string4 : this.slocales) {
            if ("default".equals(string4)) {
                object4 = string4;
                continue;
            }
            this.allLocales.add(string4);
            if (!string4.equals(string2)) continue;
            bl2 = true;
        }
        if (!bl2) {
            this.allLocales.add(string2);
        }
        if (object4 != null) {
            this.languageCombo.addItem(this.oriTrans.get(object4));
        }
        for (String string7 : this.allLocales) {
            String string8 = this.oriTrans.get(string7);
            if ("default".equals(string7)) continue;
            this.languageCombo.addItem(string8 == null ? string7 : string8);
        }
        this.languageCombo.setSelectedItem(object2);
    }

    public static LocaleDialog getInstance(GraphicManager graphicManager) {
        Dialog dialog = null;
        if (dialog == null) {
            dialog = new LocaleDialog(graphicManager.getFrame());
        } else {
            dialog.setTitle(Messages.getString("Text.LocaleDialog"));
        }
        ((AbstractDialog)dialog).addDocHelp("Locale_Dialog");
        return dialog;
    }

    private LocaleDialog(Frame frame) {
        super(frame, "", true);
        this.languageCombo = new JComboBox();
        this.countryCombo = new JComboBox();
        this.messageArea = new JTextPane();
        this.messageArea.setBackground(null);
        this.externalList = new JTable();
    }

    protected void displayMessage(String string) {
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        AttributeSet attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.RED);
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.Alignment, 3);
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.Italic, true);
        this.messageArea.setCaretPosition(0);
        this.messageArea.selectAll();
        this.messageArea.setCharacterAttributes(attributeSet, false);
        this.messageArea.replaceSelection(string);
    }

    protected void displayChangeMessage() {
        this.displayMessage(Messages.getString("Message.localeChange"));
    }

    protected void initControls() {
        this.bind(true);
        this.languageCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocaleDialog.this.displayChangeMessage();
            }
        });
        this.countryCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocaleDialog.this.displayChangeMessage();
            }
        });
        this.externalCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocaleDialog.this.directoryField.setEnabled(LocaleDialog.this.externalCheckbox.isSelected());
                LocaleDialog.this.directorySetButton.setEnabled(LocaleDialog.this.externalCheckbox.isSelected());
                LocaleDialog.this.directoryUpdateButton.setEnabled(LocaleDialog.this.externalCheckbox.isSelected());
                LocaleDialog.this.directoryExportButton.setEnabled(LocaleDialog.this.externalCheckbox.isSelected());
                LocaleDialog.this.displayChangeMessage();
            }
        });
        this.directoryField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LocaleDialog.this.displayChangeMessage();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LocaleDialog.this.displayChangeMessage();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LocaleDialog.this.displayChangeMessage();
            }
        });
        this.directorySetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                String string = LocaleDialog.this.directoryField.getText();
                if (string == null || string == "") {
                    file = FileSystemView.getFileSystemView().getHomeDirectory();
                } else {
                    file = new File(string);
                    if (!file.isDirectory()) {
                        file = FileSystemView.getFileSystemView().getHomeDirectory();
                    }
                }
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setFileSelectionMode(1);
                if (jFileChooser.showOpenDialog(LocaleDialog.this) == 0) {
                    LocaleDialog.this.displayChangeMessage();
                    File file2 = jFileChooser.getSelectedFile();
                    LocaleDialog.this.directoryField.setText(file2.getPath());
                    LocaleDialog.this.refreshFiles();
                }
            }
        });
        this.directoryUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocaleDialog.this.displayChangeMessage();
                LocaleDialog.this.refreshFiles();
            }
        });
        this.directoryExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LocaleDialog.this.displayChangeMessage();
                LocaleDialog.this.refreshExportFiles();
            }
        });
        this.externalListModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int n) {
                return LocaleDialog.this.externalListColumns[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n < 0 || n2 < 0 || n >= this.getRowCount() || n2 >= this.getColumnCount()) {
                    return null;
                }
                LanguageProperties languageProperties = LocaleDialog.this.files.get(n);
                if (n2 == 0) {
                    return languageProperties.getCode();
                }
                if (n2 == 1) {
                    return languageProperties.getClientStatus();
                }
                return languageProperties.getMenuStatus();
            }

            @Override
            public int getRowCount() {
                return LocaleDialog.this.files.size();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }
        };
        this.externalList.setModel(this.externalListModel);
        this.externalList.setEnabled(false);
    }

    public void exportResourceFile(Class clazz, String string) {
        File file = ConfigurationFile.getGeneratedDirectory(this.directoryField.getText());
        if (file == null) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream inputStream = clazz.getResourceAsStream(string + ".properties");
            if (inputStream == null) {
                throw new FileNotFoundException();
            }
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            File file2 = new File(file, string + ".properties");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            ((OutputStream)fileOutputStream).write(byArray);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void exportResourceFileUTF8(Class clazz, String string) {
        File file = ConfigurationFile.getExportDirectory(this.directoryField.getText());
        if (file == null) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream inputStream = clazz.getResourceAsStream(string + ".properties");
            if (inputStream == null) {
                throw new FileNotFoundException();
            }
            String string2 = LocaleDialog.getFileContent(inputStream, "ISO-8859-1", true);
            File file2 = new File(file, string + ".txt");
            FileWriter fileWriter = new FileWriter(file2);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void refreshFiles() {
        LanguageProperties languageProperties;
        File file;
        String string;
        String string2;
        Matcher matcher;
        this.files.clear();
        File file2 = new File(this.directoryField.getText());
        if (!file2.isDirectory()) {
            this.displayMessage(Messages.getString("Message.badLocaleDirectory"));
            if (this.externalListModel != null) {
                this.externalListModel.fireTableDataChanged();
            }
            return;
        }
        File file3 = new File(file2, "import");
        if (file3.exists()) {
            if (!file3.isDirectory()) {
                this.displayMessage(Messages.getString("Message.badLocaleDirectory"));
                if (this.externalListModel != null) {
                    this.externalListModel.fireTableDataChanged();
                }
                return;
            }
        } else if (!file3.mkdir()) {
            this.displayMessage(Messages.getString("Message.badLocaleDirectory"));
            if (this.externalListModel != null) {
                this.externalListModel.fireTableDataChanged();
            }
            return;
        }
        final Pattern pattern = Pattern.compile("client_([^_]{2,3}(_[^_]{2,3})?(_[^_]{2,3})?)(\\.(properties|txt|rtf))$");
        final Pattern pattern2 = Pattern.compile("menu_([^_]{2,3}(_[^_]{2,3})?(_[^_]{2,3})?)(\\.(properties|txt|rtf))$");
        File[] fileArray = file2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && pattern.matcher(file.getName()).matches();
            }
        });
        File[] fileArray2 = file2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && pattern2.matcher(file.getName()).matches();
            }
        });
        this.exportResourceFile(Messages.class, "client");
        TreeMap<String, LanguageProperties> treeMap = new TreeMap<String, LanguageProperties>();
        for (File file4 : fileArray) {
            matcher = pattern.matcher(file4.getName());
            if (!matcher.matches()) continue;
            string2 = matcher.group(1);
            string = matcher.group(5);
            if (string == null) continue;
            file = null;
            file = this.convertToPropertyFile(file4, new File(file3, "client_" + string2 + ".properties"), string);
            if (file == null) continue;
            if (treeMap.containsKey(string2)) {
                languageProperties = (LanguageProperties)treeMap.get(string2);
                languageProperties.setClient(file4);
                languageProperties.setClientStatus(file == null ? FileStatus.ERROR : FileStatus.OK);
                continue;
            }
            treeMap.put(string2, new LanguageProperties(string2, file4, file == null ? FileStatus.ERROR : FileStatus.OK, null, FileStatus.MISSING));
        }
        this.exportResourceFile(MenuManager.class, "menu");
        for (File file4 : fileArray2) {
            matcher = pattern2.matcher(file4.getName());
            if (!matcher.matches()) continue;
            string2 = matcher.group(1);
            string = matcher.group(5);
            if (string == null) continue;
            file = null;
            file = this.convertToPropertyFile(file4, new File(file3, "menu_" + string2 + ".properties"), string);
            if (file == null) continue;
            if (treeMap.containsKey(string2)) {
                languageProperties = (LanguageProperties)treeMap.get(string2);
                languageProperties.setMenu(file4);
                languageProperties.setMenuStatus(file == null ? FileStatus.ERROR : FileStatus.OK);
                continue;
            }
            treeMap.put(string2, new LanguageProperties(string2, null, FileStatus.MISSING, file4, file == null ? FileStatus.ERROR : FileStatus.OK));
        }
        this.files.addAll(treeMap.values());
        this.updateLocales(false);
        this.externalListModel.fireTableDataChanged();
    }

    public void refreshExportFiles() {
        File file = new File(this.directoryField.getText());
        if (!file.isDirectory()) {
            this.displayMessage(Messages.getString("Message.badLocaleDirectory"));
            if (this.externalListModel != null) {
                this.externalListModel.fireTableDataChanged();
            }
            return;
        }
        File file2 = new File(file, "export");
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                this.displayMessage(Messages.getString("Message.badLocaleDirectory"));
                if (this.externalListModel != null) {
                    this.externalListModel.fireTableDataChanged();
                }
                return;
            }
        } else if (!file2.mkdir()) {
            this.displayMessage(Messages.getString("Message.badLocaleDirectory"));
            if (this.externalListModel != null) {
                this.externalListModel.fireTableDataChanged();
            }
            return;
        }
        this.exportResourceFileUTF8(Messages.class, "client");
        this.exportResourceFileUTF8(MenuManager.class, "menu");
        for (String string : this.slocales) {
            if ("default".equals(string)) continue;
            this.exportResourceFileUTF8(Messages.class, "client_" + string);
            this.exportResourceFileUTF8(MenuManager.class, "menu_" + string);
        }
    }

    public static String getFileContent(InputStream inputStream, String string, boolean bl) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(bl ? LocaleDialog.unescape(string2) : string2);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String escapeProperties(String string) {
        CharsetEncoder charsetEncoder = Charset.forName("ISO-8859-1").newEncoder();
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (charsetEncoder.canEncode(c.charValue())) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("\\u");
            stringBuilder.append(Integer.toHexString(0x10000 | c.charValue()).substring(1).toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        string = StringEscapeUtils.unescapeJava(string);
        return string;
    }

    public File convertToPropertyFile(File file, File file2, String string) {
        try {
            Object object;
            Object object2;
            FileInputStream fileInputStream = new FileInputStream(file);
            String string2 = null;
            if ("rtf".equals(string)) {
                try {
                    object2 = new RTFEditorKit();
                    object = new DefaultStyledDocument();
                    ((RTFEditorKit)object2).read(fileInputStream, (Document)object, 0);
                    string2 = ((AbstractDocument)object).getText(0, ((AbstractDocument)object).getLength());
                    string2 = LocaleDialog.escapeProperties(string2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            } else if ("txt".equals(string)) {
                string2 = LocaleDialog.getFileContent(fileInputStream, "UTF-8", false);
                string2 = LocaleDialog.escapeProperties(string2);
            } else {
                string2 = LocaleDialog.getFileContent(fileInputStream, "ISO-8859-1", false);
            }
            if (string2 == null) {
                return null;
            }
            object2 = string2.getBytes();
            object = new FileOutputStream(file2);
            ((FileOutputStream)object).write((byte[])object2);
            ((FileOutputStream)object).close();
            return file2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("default, 3dlu, fill:80dlu:grow, 3dlu, default", "p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        defaultFormBuilder.append(Messages.getString("Text.ExternalLocaleDirectory"));
        defaultFormBuilder.append(this.directoryField);
        defaultFormBuilder.append(this.directorySetButton);
        JPanel jPanel = defaultFormBuilder.getPanel();
        FormLayout formLayout2 = new FormLayout("default, 3dlu, default, 3dlu, default, 3dlu, fill:80dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, 100dlu, 20dlu, p");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder2.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder2.append(Messages.getString("Text.Language"));
        defaultFormBuilder2.append(this.languageCombo);
        defaultFormBuilder2.nextLine(2);
        defaultFormBuilder2.append(Messages.getString("Text.Country"));
        defaultFormBuilder2.append(this.countryCombo);
        defaultFormBuilder2.nextLine(2);
        defaultFormBuilder2.addSeparator(Messages.getString("Text.ExternalLocale"));
        defaultFormBuilder2.nextLine(2);
        defaultFormBuilder2.add((Component)this.externalCheckbox, cellConstraints.xyw(defaultFormBuilder2.getColumn(), defaultFormBuilder2.getRow(), 7));
        defaultFormBuilder2.nextLine(2);
        defaultFormBuilder2.add((Component)jPanel, cellConstraints.xyw(defaultFormBuilder2.getColumn(), defaultFormBuilder2.getRow(), 7));
        defaultFormBuilder2.nextLine(2);
        defaultFormBuilder2.append(Messages.getString("Text.Locales"));
        defaultFormBuilder2.append(this.directoryUpdateButton);
        defaultFormBuilder2.append(this.directoryExportButton);
        defaultFormBuilder2.nextLine(2);
        defaultFormBuilder2.add((Component)new JScrollPane(this.externalList), cellConstraints.xyw(defaultFormBuilder2.getColumn(), defaultFormBuilder2.getRow(), 7));
        defaultFormBuilder2.nextLine(2);
        defaultFormBuilder2.add((Component)this.messageArea, cellConstraints.xyw(defaultFormBuilder2.getColumn(), defaultFormBuilder2.getRow(), 7));
        return defaultFormBuilder2.getPanel();
    }

    static class Country
    implements Comparable<Country> {
        String code;
        String name;

        public Country() {
            this.code = "";
            this.name = "";
        }

        public Country(String string, String string2) {
            this.code = string;
            this.name = string2;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String string) {
            this.code = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int hashCode() {
            return this.code.hashCode();
        }

        public String toString() {
            return this.name.toString();
        }

        @Override
        public int compareTo(Country country) {
            return this.code.compareTo(country.getCode());
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Country)) {
                return false;
            }
            return this.code.equals(((Country)object).getCode());
        }
    }

    class LanguageProperties
    implements Comparable<String> {
        String code;
        File client;
        FileStatus clientStatus;
        File menu;
        FileStatus menuStatus;

        public LanguageProperties(String string, File file, FileStatus fileStatus, File file2, FileStatus fileStatus2) {
            this.code = string;
            this.client = file;
            this.clientStatus = fileStatus;
            this.menu = file2;
            this.menuStatus = fileStatus2;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String string) {
            this.code = string;
        }

        public File getClient() {
            return this.client;
        }

        public void setClient(File file) {
            this.client = file;
        }

        public File getMenu() {
            return this.menu;
        }

        public void setMenu(File file) {
            this.menu = file;
        }

        public FileStatus getClientStatus() {
            return this.clientStatus;
        }

        public void setClientStatus(FileStatus fileStatus) {
            this.clientStatus = fileStatus;
        }

        public FileStatus getMenuStatus() {
            return this.menuStatus;
        }

        public void setMenuStatus(FileStatus fileStatus) {
            this.menuStatus = fileStatus;
        }

        @Override
        public int compareTo(String string) {
            return this.code.compareTo(string);
        }
    }

    public static enum FileStatus {
        OK(Messages.getString("LocaleDialog.FileStatusOk")),
        MISSING(Messages.getString("LocaleDialog.FileStatusMissing")),
        ERROR(Messages.getString("LocaleDialog.FileStatusFormatError"));

        public final String message;

        private FileStatus(String string2) {
            this.message = string2;
        }
    }
}

