/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

class IndeterminateProgressMonitor {
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar progressBar;
    private final JLabel noteLabel;
    private Object[] cancelOption = new Object[]{UIManager.getString("OptionPane.cancelButtonText")};

    IndeterminateProgressMonitor(Component component, Object object, String string) {
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.noteLabel = new JLabel(string);
        this.pane = new IndefiniteProgressOptionPane(object, this.noteLabel, this.progressBar);
        this.dialog = this.pane.createDialog(component, "Progress");
        this.dialog.setVisible(true);
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.progressBar = null;
        }
    }

    public boolean isCanceled() {
        Object object = this.pane.getValue();
        return object != null && this.cancelOption.length == 1 && object.equals(this.cancelOption[0]);
    }

    public void setNote(String string) {
        this.noteLabel.setText(string);
    }

    private class IndefiniteProgressOptionPane
    extends JOptionPane {
        IndefiniteProgressOptionPane(Object ... objectArray) {
            super(objectArray, 1, -1, null, IndeterminateProgressMonitor.this.cancelOption, null);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 80, this.getPreferredSize().height));
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public JDialog createDialog(Component component, String string) throws HeadlessException {
            JDialog jDialog = super.createDialog(component, string);
            jDialog.setModal(false);
            return jDialog;
        }
    }
}

