/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct MDB_stat")
public class MDBStat
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MS_PSIZE;
    public static final int MS_DEPTH;
    public static final int MS_BRANCH_PAGES;
    public static final int MS_LEAF_PAGES;
    public static final int MS_OVERFLOW_PAGES;
    public static final int MS_ENTRIES;

    public MDBStat(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MDBStat.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int ms_psize() {
        return MDBStat.nms_psize(this.address());
    }

    @NativeType(value="unsigned int")
    public int ms_depth() {
        return MDBStat.nms_depth(this.address());
    }

    @NativeType(value="size_t")
    public long ms_branch_pages() {
        return MDBStat.nms_branch_pages(this.address());
    }

    @NativeType(value="size_t")
    public long ms_leaf_pages() {
        return MDBStat.nms_leaf_pages(this.address());
    }

    @NativeType(value="size_t")
    public long ms_overflow_pages() {
        return MDBStat.nms_overflow_pages(this.address());
    }

    @NativeType(value="size_t")
    public long ms_entries() {
        return MDBStat.nms_entries(this.address());
    }

    public static MDBStat malloc() {
        return (MDBStat)MDBStat.wrap(MDBStat.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MDBStat calloc() {
        return (MDBStat)MDBStat.wrap(MDBStat.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MDBStat create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MDBStat)MDBStat.wrap(MDBStat.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MDBStat create(long address) {
        return (MDBStat)MDBStat.wrap(MDBStat.class, (long)address);
    }

    @Nullable
    public static MDBStat createSafe(long address) {
        return address == 0L ? null : (MDBStat)MDBStat.wrap(MDBStat.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MDBStat.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MDBStat.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MDBStat.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MDBStat.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MDBStat.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MDBStat.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MDBStat.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MDBStat mallocStack() {
        return MDBStat.mallocStack(MemoryStack.stackGet());
    }

    public static MDBStat callocStack() {
        return MDBStat.callocStack(MemoryStack.stackGet());
    }

    public static MDBStat mallocStack(MemoryStack stack) {
        return (MDBStat)MDBStat.wrap(MDBStat.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MDBStat callocStack(MemoryStack stack) {
        return (MDBStat)MDBStat.wrap(MDBStat.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MDBStat.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MDBStat.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MDBStat.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MDBStat.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nms_psize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MS_PSIZE);
    }

    public static int nms_depth(long struct) {
        return UNSAFE.getInt(null, struct + (long)MS_DEPTH);
    }

    public static long nms_branch_pages(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MS_BRANCH_PAGES));
    }

    public static long nms_leaf_pages(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MS_LEAF_PAGES));
    }

    public static long nms_overflow_pages(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MS_OVERFLOW_PAGES));
    }

    public static long nms_entries(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MS_ENTRIES));
    }

    static {
        Struct.Layout layout = MDBStat.__struct((Struct.Member[])new Struct.Member[]{MDBStat.__member((int)4), MDBStat.__member((int)4), MDBStat.__member((int)POINTER_SIZE), MDBStat.__member((int)POINTER_SIZE), MDBStat.__member((int)POINTER_SIZE), MDBStat.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MS_PSIZE = layout.offsetof(0);
        MS_DEPTH = layout.offsetof(1);
        MS_BRANCH_PAGES = layout.offsetof(2);
        MS_LEAF_PAGES = layout.offsetof(3);
        MS_OVERFLOW_PAGES = layout.offsetof(4);
        MS_ENTRIES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<MDBStat, Buffer>
    implements NativeResource {
        private static final MDBStat ELEMENT_FACTORY = MDBStat.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MDBStat getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int ms_psize() {
            return MDBStat.nms_psize(this.address());
        }

        @NativeType(value="unsigned int")
        public int ms_depth() {
            return MDBStat.nms_depth(this.address());
        }

        @NativeType(value="size_t")
        public long ms_branch_pages() {
            return MDBStat.nms_branch_pages(this.address());
        }

        @NativeType(value="size_t")
        public long ms_leaf_pages() {
            return MDBStat.nms_leaf_pages(this.address());
        }

        @NativeType(value="size_t")
        public long ms_overflow_pages() {
            return MDBStat.nms_overflow_pages(this.address());
        }

        @NativeType(value="size_t")
        public long ms_entries() {
            return MDBStat.nms_entries(this.address());
        }
    }
}

