/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXCallbackVtbl;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_callback_interface_t")
public class BGFXCallbackInterface
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTBL;

    public BGFXCallbackInterface(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXCallbackInterface.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_callback_vtbl_t const *")
    public BGFXCallbackVtbl vtbl() {
        return BGFXCallbackInterface.nvtbl(this.address());
    }

    public BGFXCallbackInterface vtbl(@NativeType(value="bgfx_callback_vtbl_t const *") BGFXCallbackVtbl value) {
        BGFXCallbackInterface.nvtbl(this.address(), value);
        return this;
    }

    public BGFXCallbackInterface set(BGFXCallbackInterface src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXCallbackInterface malloc() {
        return (BGFXCallbackInterface)BGFXCallbackInterface.wrap(BGFXCallbackInterface.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXCallbackInterface calloc() {
        return (BGFXCallbackInterface)BGFXCallbackInterface.wrap(BGFXCallbackInterface.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXCallbackInterface create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXCallbackInterface)BGFXCallbackInterface.wrap(BGFXCallbackInterface.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXCallbackInterface create(long address) {
        return (BGFXCallbackInterface)BGFXCallbackInterface.wrap(BGFXCallbackInterface.class, (long)address);
    }

    @Nullable
    public static BGFXCallbackInterface createSafe(long address) {
        return address == 0L ? null : (BGFXCallbackInterface)BGFXCallbackInterface.wrap(BGFXCallbackInterface.class, (long)address);
    }

    public static BGFXCallbackInterface mallocStack() {
        return BGFXCallbackInterface.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackInterface callocStack() {
        return BGFXCallbackInterface.callocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackInterface mallocStack(MemoryStack stack) {
        return (BGFXCallbackInterface)BGFXCallbackInterface.wrap(BGFXCallbackInterface.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXCallbackInterface callocStack(MemoryStack stack) {
        return (BGFXCallbackInterface)BGFXCallbackInterface.wrap(BGFXCallbackInterface.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static BGFXCallbackVtbl nvtbl(long struct) {
        return BGFXCallbackVtbl.create(MemoryUtil.memGetAddress((long)(struct + (long)VTBL)));
    }

    public static void nvtbl(long struct, BGFXCallbackVtbl value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VTBL), (long)value.address());
    }

    public static void validate(long struct) {
        long vtbl = MemoryUtil.memGetAddress((long)(struct + (long)VTBL));
        Checks.check((long)vtbl);
        BGFXCallbackVtbl.validate(vtbl);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXCallbackInterface.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = BGFXCallbackInterface.__struct((Struct.Member[])new Struct.Member[]{BGFXCallbackInterface.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTBL = layout.offsetof(0);
    }
}

