/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Window;
import java.io.File;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import javax.swing.event.EventListenerList;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.event.ApplicationEvent;
import net.sourceforge.jnlp.event.ApplicationListener;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.dialogs.AccessWarningPaneComplexReturn;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.XDesktopEntry;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.awt.AppContext;

public class ApplicationInstance {
    private final JNLPFile file;
    private final ThreadGroup group;
    private final ClassLoader loader;
    private final AppContext appContext;
    private boolean stopped = false;
    private final WeakList<Window> weakWindows = new WeakList();
    private final EventListenerList listeners = new EventListenerList();
    private boolean isSigned = false;

    public ApplicationInstance(JNLPFile file, ThreadGroup group, ClassLoader loader) {
        this.file = file;
        this.group = group;
        this.loader = loader;
        this.isSigned = ((JNLPClassLoader)loader).getSigning();
        this.appContext = AppContext.getAppContext();
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.listeners.add(ApplicationListener.class, listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.listeners.remove(ApplicationListener.class, listener);
    }

    protected void fireDestroyed() {
        Object[] list = this.listeners.getListenerList();
        ApplicationEvent event = null;
        for (int i = list.length - 1; i > 0; i -= 2) {
            if (event == null) {
                event = new ApplicationEvent(this);
            }
            ((ApplicationListener)list[i]).applicationDestroyed(event);
        }
    }

    public void initialize() {
        this.installEnvironment();
        this.addMenuAndDesktopEntries();
    }

    private void addMenuAndDesktopEntries() {
        XDesktopEntry entry = new XDesktopEntry(this.file);
        ShortcutDesc sd = this.file.getInformation().getShortcut();
        File possibleDesktopFile = entry.getLinuxDesktopIconFile();
        File possibleMenuFile = entry.getLinuxMenuIconFile();
        File generatedJnlp = entry.getGeneratedJnlpFileName();
        boolean exists = false;
        if (possibleDesktopFile.exists()) {
            OutputController.getLogger().log("ApplicationInstance.addMenuAndDesktopEntries(): file - " + possibleDesktopFile.getAbsolutePath() + " already exists. Refreshing and not proceeding with desktop additions");
            exists = true;
            if (JNLPRuntime.isOnline()) {
                entry.refreshExistingShortcuts(false, true);
            }
        }
        if (possibleMenuFile.exists()) {
            OutputController.getLogger().log("ApplicationInstance.addMenuAndDesktopEntries(): file - " + possibleMenuFile.getAbsolutePath() + " already exists. Refreshing and not proceeding with desktop additions");
            exists = true;
            if (JNLPRuntime.isOnline()) {
                entry.refreshExistingShortcuts(true, false);
            }
        }
        if (generatedJnlp.exists()) {
            OutputController.getLogger().log("ApplicationInstance.addMenuAndDesktopEntries(): generated file - " + generatedJnlp.getAbsolutePath() + " already exists. Refreshing and not proceeding with desktop additions");
            exists = true;
            if (JNLPRuntime.isOnline()) {
                entry.refreshExistingShortcuts(true, true);
            }
        }
        if (exists) {
            return;
        }
        AccessWarningPaneComplexReturn ics = this.getComplexReturn(sd);
        if (ics.getRegularReturnAsBoolean()) {
            entry.createDesktopShortcuts(ics.getMenu(), ics.getDekstop(), this.isSigned());
        }
    }

    private AccessWarningPaneComplexReturn getComplexReturn(ShortcutDesc sd) {
        String currentSetting;
        if (JNLPRuntime.isTrustAll()) {
            boolean mainResult = sd != null && (sd.onDesktop() || sd.getMenu() != null);
            AccessWarningPaneComplexReturn r = new AccessWarningPaneComplexReturn(mainResult ? 0 : 1);
            if (mainResult) {
                if (sd.onDesktop()) {
                    r.setDekstop(new AccessWarningPaneComplexReturn.ShortcutResult(true));
                    r.getDekstop().setBrowser(XDesktopEntry.getBrowserBin());
                    r.getDekstop().setShortcutType(AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.BROWSER);
                }
                if (sd.getMenu() != null) {
                    r.setMenu(new AccessWarningPaneComplexReturn.ShortcutResult(true));
                    r.getMenu().setBrowser(XDesktopEntry.getBrowserBin());
                    r.getMenu().setShortcutType(AccessWarningPaneComplexReturn.ShortcutResult.Shortcut.BROWSER);
                }
            }
            return r;
        }
        switch (currentSetting = JNLPRuntime.getConfiguration().getProperty("deployment.javaws.shortcut")) {
            case "NEVER": {
                return new AccessWarningPaneComplexReturn(1);
            }
            case "ALWAYS": {
                return new AccessWarningPaneComplexReturn(0);
            }
            case "ASK_USER": {
                return SecurityDialogs.showAccessWarningDialogComplexReturn(SecurityDialogs.AccessType.CREATE_DESTKOP_SHORTCUT, this.file);
            }
            case "ASK_IF_HINTED": {
                if (sd != null && (sd.onDesktop() || sd.toMenu())) {
                    return SecurityDialogs.showAccessWarningDialogComplexReturn(SecurityDialogs.AccessType.CREATE_DESTKOP_SHORTCUT, this.file);
                }
            }
            case "ALWAYS_IF_HINTED": {
                if (sd == null || !sd.onDesktop() && !sd.toMenu()) break;
                return new AccessWarningPaneComplexReturn(0);
            }
        }
        return new AccessWarningPaneComplexReturn(1);
    }

    public void finalize() {
        this.destroy();
    }

    void installEnvironment() {
        final PropertyDesc[] props = this.file.getResources().getProperties();
        CodeSource cs = new CodeSource((URL)null, (Certificate[])null);
        JNLPClassLoader loader = (JNLPClassLoader)this.loader;
        SecurityDesc s = loader.getSecurity();
        ProtectionDomain pd = new ProtectionDomain(cs, s.getPermissions(cs), null, null);
        AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{pd});
        PrivilegedAction<Object> installProps = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (PropertyDesc propDesc : props) {
                    System.setProperty(propDesc.getKey(), propDesc.getValue());
                }
                return null;
            }
        };
        AccessController.doPrivileged(installProps, acc);
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.stopped) {
            return;
        }
        try {
            int i;
            for (Window w : this.weakWindows) {
                if (w == null) continue;
                w.dispose();
            }
            this.weakWindows.clear();
            Thread[] threads = new Thread[this.group.activeCount() * 2];
            int nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                OutputController.getLogger().log("Interrupt thread: " + threads[i]);
                threads[i].interrupt();
            }
            Thread.yield();
            nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                OutputController.getLogger().log("Stop thread: " + threads[i]);
                threads[i].stop();
            }
        }
        finally {
            this.stopped = true;
            this.fireDestroyed();
        }
    }

    public ThreadGroup getThreadGroup() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.group;
    }

    public ClassLoader getClassLoader() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.loader;
    }

    protected void addWindow(Window window) {
        this.weakWindows.add(window);
        this.weakWindows.trimToSize();
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public AppContext getAppContext() {
        return this.appContext;
    }
}

