/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.settings;

import com.almworks.tracklink.codelinks.CodeLinkType;
import com.almworks.tracklink.dialogs.CorrectnessChangeListener;
import com.almworks.tracklink.dialogs.DialogOrientedComponent;
import com.almworks.tracklink.settings.wizards.PatternSettingsWizard;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.almworks.util.ui.ColorUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RefTypeEditForm
extends DialogOrientedComponent {
    private static final Color DEFAULT_FOREGROUND = UIManager.getColor("Textfield.foreground");
    private static final String SPECIAL_PATTERN_CHARACTERS = ".*+?() ";
    private JTextField mySearchPatternField;
    private JTextField myReplacePatternField;
    private JTextField myTestExpressionField;
    private JTextField myResultField;
    private JLabel searchLabel;
    private JLabel replaceLabel;
    private JLabel testLabel;
    private JPanel myMainPanel;
    private DocumentAdapter myDocumentListener;
    private Map<JButton, ActionListener> myWizardListeners;
    private JPanel myWizardsPanel;
    private PatternSettingsWizard[] myWizards;

    public RefTypeEditForm(CodeLinkType type, PatternSettingsWizard[] wizards) {
        this.$$$setupUI$$$();
        this.myWizardListeners = new HashMap();
        this.myWizards = wizards;
        this.searchLabel.setLabelFor(this.mySearchPatternField);
        this.replaceLabel.setLabelFor(this.myReplacePatternField);
        this.testLabel.setLabelFor(this.myTestExpressionField);
        this.mySearchPatternField.setText(type.getPatternString());
        this.myReplacePatternField.setText(type.getReplacePattern());
        this.createWizardsButtons();
        this.attachListeners();
        this.checkCorrectness();
    }

    private void createWizardsButtons() {
        for (final PatternSettingsWizard wizard : this.myWizards) {
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Pair<String, String> pair = wizard.requestUser(RefTypeEditForm.this.getCenterPanel());
                    if (pair != null) {
                        RefTypeEditForm.this.mySearchPatternField.setText((String)pair.getFirst());
                        RefTypeEditForm.this.myReplacePatternField.setText((String)pair.getSecond());
                    }
                }
            };
            JButton button = new JButton(wizard.getName());
            Utils.setMnemonicIfNeed(button);
            button.addActionListener(listener);
            this.myWizardsPanel.add(button);
            this.myWizardListeners.put(button, listener);
        }
    }

    public String getSearchPattern() {
        return this.mySearchPatternField.getText().trim();
    }

    public String getReplacePattern() {
        return this.myReplacePatternField.getText();
    }

    public JComponent getCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchPatternField;
    }

    private void attachListeners() {
        this.myDocumentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                boolean correctNow = RefTypeEditForm.this.checkCorrectness();
                for (CorrectnessChangeListener myListener : RefTypeEditForm.this.myCorrectnessChangeListeners) {
                    myListener.correctnessChanged(correctNow);
                }
            }
        };
        this.myTestExpressionField.getDocument().addDocumentListener((DocumentListener)this.myDocumentListener);
        this.mySearchPatternField.getDocument().addDocumentListener((DocumentListener)this.myDocumentListener);
        this.myReplacePatternField.getDocument().addDocumentListener((DocumentListener)this.myDocumentListener);
    }

    protected boolean checkCorrectness() {
        Pattern searcher;
        String searchPattern = this.getSearchPattern();
        String replacePattern = this.getReplacePattern();
        String source = this.myTestExpressionField.getText();
        if (searchPattern.length() == 0) {
            this.showError("codelink.edit.error.nopattern");
            return false;
        }
        if (replacePattern.length() == 0) {
            this.showError("codelink.edit.error.noreplacement");
            return false;
        }
        try {
            searcher = Pattern.compile(searchPattern, 2);
        }
        catch (Exception e1) {
            this.showError("codelink.edit.error.badpattern");
            return false;
        }
        boolean isOnlySpecialSymbols = true;
        for (int i = 0; i < searchPattern.length(); ++i) {
            if (SPECIAL_PATTERN_CHARACTERS.indexOf(searchPattern.charAt(i)) != -1) continue;
            isOnlySpecialSymbols = false;
        }
        if (isOnlySpecialSymbols) {
            this.showError("codelink.edit.error.toogenericpattern");
            return false;
        }
        if (searchPattern.indexOf(32) != -1) {
            this.showError("codelink.edit.error.space_warning");
            return false;
        }
        Matcher searchMatcher = searcher.matcher(source.trim());
        try {
            this.myResultField.setForeground(DEFAULT_FOREGROUND);
            if (searchMatcher.matches()) {
                this.myResultField.setText(searchMatcher.replaceAll(replacePattern));
            } else {
                this.myResultField.setText(StringBundle.get("codelink.edit.error.notmatched", new Object[0]));
            }
        }
        catch (Exception e1) {
            this.showError("codelink.edit.error.badgroupreferences");
            return false;
        }
        return true;
    }

    private void showError(String messageKey) {
        this.myResultField.setForeground(ColorUtil.ERROR_COLOR);
        this.myResultField.setText(StringBundle.get(messageKey, new Object[0]));
    }

    public void detachListeners() {
        this.mySearchPatternField.getDocument().removeDocumentListener((DocumentListener)this.myDocumentListener);
        this.myReplacePatternField.getDocument().removeDocumentListener((DocumentListener)this.myDocumentListener);
        this.myTestExpressionField.getDocument().removeDocumentListener((DocumentListener)this.myDocumentListener);
        for (JButton button : this.myWizardListeners.keySet()) {
            button.removeActionListener(this.myWizardListeners.get(button));
        }
        this.myCorrectnessChangeListeners.clear();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.searchLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.pattern"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.replaceLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.replacement"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.testLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.test"));
        jPanel2.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.result"));
        jPanel2.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySearchPatternField = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myReplacePatternField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTestExpressionField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myResultField = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setEditable(false);
        ((Component)jTextField).setEnabled(true);
        jPanel2.add((Component)jTextField, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 19), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.helptext"));
        jLabel5.setHorizontalAlignment(2);
        jLabel5.setVerticalTextPosition(3);
        jLabel5.setVerticalAlignment(3);
        jLabel5.setHorizontalTextPosition(2);
        jPanel2.add((Component)jLabel5, new GridConstraints(7, 0, 1, 2, 9, 3, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 1, null, new Dimension(400, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWizardsPanel = jPanel = new JPanel();
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

