/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;

public class ChunkedOutputFilter
implements OutputFilter {
    private static final byte[] END_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
    protected HttpOutputBuffer buffer;
    protected final ByteBuffer chunkHeader = ByteBuffer.allocate(10);
    protected final ByteBuffer endChunk = ByteBuffer.wrap(END_CHUNK_BYTES);

    public ChunkedOutputFilter() {
        this.chunkHeader.put(8, (byte)13);
        this.chunkHeader.put(9, (byte)10);
    }

    @Override
    @Deprecated
    public int doWrite(ByteChunk chunk) throws IOException {
        int result = chunk.getLength();
        if (result <= 0) {
            return 0;
        }
        int pos = this.calculateChunkHeader(result);
        this.chunkHeader.position(pos).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        this.buffer.doWrite(chunk);
        this.chunkHeader.position(8).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        return result;
    }

    @Override
    public int doWrite(ByteBuffer chunk) throws IOException {
        int result = chunk.remaining();
        if (result <= 0) {
            return 0;
        }
        int pos = this.calculateChunkHeader(result);
        this.chunkHeader.position(pos).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        this.buffer.doWrite(chunk);
        this.chunkHeader.position(8).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        return result;
    }

    private int calculateChunkHeader(int len) {
        int pos = 8;
        for (int current = len; current > 0; current /= 16) {
            int digit = current % 16;
            this.chunkHeader.put(--pos, HexUtils.getHex((int)digit));
        }
        return pos;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(HttpOutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void end() throws IOException {
        this.buffer.doWrite(this.endChunk);
        this.endChunk.position(0).limit(this.endChunk.capacity());
        this.buffer.end();
    }

    @Override
    public void recycle() {
    }
}

