/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;

final class SpanContextShim
extends BaseShimObject
implements io.opentracing.SpanContext {
    private final SpanContext context;
    private final Baggage baggage;

    public SpanContextShim(SpanShim spanShim) {
        this(spanShim.telemetryInfo(), spanShim.getSpan().getSpanContext(), spanShim.telemetryInfo().emptyBaggage());
    }

    public SpanContextShim(TelemetryInfo telemetryInfo, SpanContext context) {
        this(telemetryInfo, context, telemetryInfo.emptyBaggage());
    }

    public SpanContextShim(TelemetryInfo telemetryInfo, SpanContext context, Baggage baggage) {
        super(telemetryInfo);
        this.context = context;
        this.baggage = baggage;
    }

    SpanContextShim newWithKeyValue(String key, String value) {
        BaggageBuilder builder = this.baggage.toBuilder();
        builder.put(key, value, BaggageEntryMetadata.empty());
        return new SpanContextShim(this.telemetryInfo(), this.context, builder.build());
    }

    SpanContext getSpanContext() {
        return this.context;
    }

    Baggage getBaggage() {
        return this.baggage;
    }

    public String toTraceId() {
        return this.context.getTraceId();
    }

    public String toSpanId() {
        return this.context.getSpanId();
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        ArrayList<Map.Entry<String, String>> items = new ArrayList<Map.Entry<String, String>>(this.baggage.size());
        this.baggage.forEach((key, baggageEntry) -> items.add(new AbstractMap.SimpleImmutableEntry<String, String>((String)key, baggageEntry.getValue())));
        return items;
    }

    @Nullable
    String getBaggageItem(String key) {
        return this.baggage.getEntryValue(key);
    }
}

