/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.opentracingshim.OpenTracingPropagators;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentelemetry.opentracingshim.TracerShim;
import io.opentracing.Tracer;

public final class OpenTracingShim {
    private OpenTracingShim() {
    }

    public static Tracer createTracerShim() {
        return OpenTracingShim.createTracerShim(OpenTracingShim.getTracer(GlobalOpenTelemetry.getTracerProvider()));
    }

    public static Tracer createTracerShim(io.opentelemetry.api.trace.Tracer tracer) {
        return OpenTracingShim.createTracerShim(tracer, OpenTracingPropagators.builder().build());
    }

    public static Tracer createTracerShim(io.opentelemetry.api.trace.Tracer tracer, OpenTracingPropagators propagators) {
        return new TracerShim(new TelemetryInfo(tracer, propagators));
    }

    public static Tracer createTracerShim(OpenTelemetry openTelemetry) {
        return OpenTracingShim.createTracerShim(OpenTracingShim.getTracer(openTelemetry.getTracerProvider()), OpenTracingPropagators.builder().setTextMap(openTelemetry.getPropagators().getTextMapPropagator()).setHttpHeaders(openTelemetry.getPropagators().getTextMapPropagator()).build());
    }

    private static io.opentelemetry.api.trace.Tracer getTracer(TracerProvider tracerProvider) {
        return tracerProvider.get("opentracing-shim");
    }
}

