/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static final Map<ClassLoader, Map<String, Class<?>>> cache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findClass(String string) {
        LinkedHashMap linkedHashMap;
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        Map<Object, Object> map = cache;
        synchronized (map) {
            linkedHashMap = cache.get(classLoader);
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<String, Class<?>>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<String, Class<?>> entry) {
                        return this.size() > 1024;
                    }
                };
                cache.put(classLoader, linkedHashMap);
            }
        }
        map = linkedHashMap;
        synchronized (map) {
            if (!linkedHashMap.containsKey(string)) {
                Class<?> clazz;
                try {
                    clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
                linkedHashMap.put(string, clazz);
            }
        }
        return (Class)linkedHashMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<ClassLoader, Map<String, Class<?>>> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    public static String toUpperCamel(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toLowerCamel(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 1 && Character.isUpperCase(stringBuilder.charAt(0)) && !Character.isUpperCase(stringBuilder.charAt(1))) {
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
        }
        return stringBuilder.toString();
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Class<?> clazz = null;
            try {
                clazz = Array.newInstance(ClassUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return clazz;
        }
        if (type instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            return typeArray.length > 0 ? ClassUtil.getRawType(typeArray[0]) : Object.class;
        }
        return Object.class;
    }

    public static ParameterizedType resolveParameterizedType(Type type, Class<?> clazz) {
        Class<?> clazz2 = ClassUtil.getRawType(type);
        if (type instanceof ParameterizedType && clazz.isAssignableFrom(clazz2)) {
            return (ParameterizedType)type;
        }
        ParameterizedType parameterizedType = null;
        if (clazz2.getSuperclass() != null && clazz2.getSuperclass() != Object.class && (parameterizedType = ClassUtil.resolveParameterizedType(clazz2.getGenericSuperclass(), clazz)) != null) {
            return parameterizedType;
        }
        if (!clazz2.isInterface()) {
            for (Type type2 : clazz2.getGenericInterfaces()) {
                parameterizedType = ClassUtil.resolveParameterizedType(type2, clazz);
                if (parameterizedType == null) continue;
                return parameterizedType;
            }
        }
        return null;
    }

    public static byte[] serialize(Object object) throws ObjectStreamException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (ObjectStreamException objectStreamException) {
            throw objectStreamException;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] byArray) throws ObjectStreamException, ClassNotFoundException {
        Object object = null;
        ContextObjectInputStream contextObjectInputStream = null;
        try {
            contextObjectInputStream = new ContextObjectInputStream(new ByteArrayInputStream(byArray));
            object = contextObjectInputStream.readObject();
            contextObjectInputStream.close();
        }
        catch (ObjectStreamException objectStreamException) {
            throw objectStreamException;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n = 1;
        Class<?> clazz = object.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                Object object2;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || field.isSynthetic()) continue;
                try {
                    field.setAccessible(true);
                    object2 = field.get(object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException(illegalAccessException);
                }
                if (object2 == null) {
                    n = 31 * n + 0;
                    continue;
                }
                if (clazz.isArray()) {
                    if (clazz.equals(boolean[].class)) {
                        n = 31 * n + Arrays.hashCode((boolean[])object2);
                        continue;
                    }
                    if (clazz.equals(char[].class)) {
                        n = 31 * n + Arrays.hashCode((char[])object2);
                        continue;
                    }
                    if (clazz.equals(byte[].class)) {
                        n = 31 * n + Arrays.hashCode((byte[])object2);
                        continue;
                    }
                    if (clazz.equals(short[].class)) {
                        n = 31 * n + Arrays.hashCode((short[])object2);
                        continue;
                    }
                    if (clazz.equals(int[].class)) {
                        n = 31 * n + Arrays.hashCode((int[])object2);
                        continue;
                    }
                    if (clazz.equals(long[].class)) {
                        n = 31 * n + Arrays.hashCode((long[])object2);
                        continue;
                    }
                    if (clazz.equals(float[].class)) {
                        n = 31 * n + Arrays.hashCode((float[])object2);
                        continue;
                    }
                    if (clazz.equals(double[].class)) {
                        n = 31 * n + Arrays.hashCode((double[])object2);
                        continue;
                    }
                    n = 31 * n + Arrays.hashCode((Object[])object2);
                    continue;
                }
                n = 31 * n + object2.hashCode();
            }
        } while (!Object.class.equals(clazz = clazz.getSuperclass()));
        return n;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!object.getClass().equals(object2.getClass())) {
            return false;
        }
        Class<?> clazz = object.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                Object object3;
                Object object4;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || field.isSynthetic()) continue;
                try {
                    field.setAccessible(true);
                    object4 = field.get(object);
                    object3 = field.get(object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException(illegalAccessException);
                }
                if (!(object4 == null ? object3 != null : (clazz.isArray() ? (clazz.equals(boolean[].class) ? !Arrays.equals((boolean[])object4, (boolean[])object3) : (clazz.equals(char[].class) ? !Arrays.equals((char[])object4, (char[])object3) : (clazz.equals(byte[].class) ? !Arrays.equals((byte[])object4, (byte[])object3) : (clazz.equals(short[].class) ? !Arrays.equals((short[])object4, (short[])object3) : (clazz.equals(int[].class) ? !Arrays.equals((int[])object4, (int[])object3) : (clazz.equals(long[].class) ? !Arrays.equals((long[])object4, (long[])object3) : (clazz.equals(float[].class) ? !Arrays.equals((float[])object4, (float[])object3) : (clazz.equals(double[].class) ? !Arrays.equals((double[])object4, (double[])object3) : !Arrays.equals((Object[])object4, (Object[])object3))))))))) : !object4.equals(object3)))) continue;
                return false;
            }
        } while (!Object.class.equals(clazz = clazz.getSuperclass()));
        return true;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        BeanInfo beanInfo = BeanInfo.get(object.getClass());
        StringBuilder stringBuilder = new StringBuilder(10 * beanInfo.getProperties().size() + 20);
        stringBuilder.append(object.getClass().getSimpleName()).append(" [");
        boolean bl = true;
        for (PropertyInfo propertyInfo : beanInfo.getProperties()) {
            if (!propertyInfo.isReadable() || propertyInfo.getName().equals("class")) continue;
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(propertyInfo.getName()).append("=");
            try {
                Object object2 = propertyInfo.get(object);
                if (object2.getClass().isArray()) {
                    if (object2 instanceof boolean[]) {
                        Arrays.toString((boolean[])object2);
                        continue;
                    }
                    if (object2 instanceof char[]) {
                        Arrays.toString((char[])object2);
                        continue;
                    }
                    if (object2 instanceof byte[]) {
                        Arrays.toString((byte[])object2);
                        continue;
                    }
                    if (object2 instanceof short[]) {
                        Arrays.toString((short[])object2);
                        continue;
                    }
                    if (object2 instanceof int[]) {
                        Arrays.toString((int[])object2);
                        continue;
                    }
                    if (object2 instanceof long[]) {
                        Arrays.toString((long[])object2);
                        continue;
                    }
                    if (object2 instanceof float[]) {
                        Arrays.toString((float[])object2);
                        continue;
                    }
                    if (object2 instanceof double[]) {
                        Arrays.toString((double[])object2);
                        continue;
                    }
                    Arrays.toString((Object[])object2);
                    continue;
                }
                stringBuilder.append(object2);
            }
            catch (Exception exception) {
                stringBuilder.append("?");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private ClassUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextObjectInputStream
    extends ObjectInputStream {
        public ContextObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                return Class.forName(objectStreamClass.getName(), true, classLoader);
            }
            catch (Exception exception) {
                return super.resolveClass(objectStreamClass);
            }
        }
    }
}

