/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerReplicaStatesFetcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PerReplicaStates fetch(String path, SolrZkClient zkClient, PerReplicaStates current) {
        try {
            Stat stat;
            if (current != null) {
                stat = zkClient.exists(current.path, null, true);
                if (stat == null) {
                    return new PerReplicaStates(path, 0, Collections.emptyList());
                }
                if (current.cversion == stat.getCversion()) {
                    return current;
                }
            }
            stat = new Stat();
            List<String> children = zkClient.getChildren(path, null, stat, true);
            return new PerReplicaStates(path, stat.getCversion(), Collections.unmodifiableList(children));
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching per-replica states", (Throwable)e);
        }
        catch (InterruptedException e) {
            SolrZkClient.checkInterrupted(e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Thread interrupted when loading per-replica states from " + path, (Throwable)e);
        }
    }

    public static class LazyPrsSupplier
    extends DocCollection.PrsSupplier {
        public LazyPrsSupplier(SolrZkClient zkClient, String collectionPath) {
            super(() -> PerReplicaStatesFetcher.fetch(collectionPath, zkClient, null));
        }
    }
}

