/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction.data;

import java.util.function.Consumer;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.stream.reservation.DoubleCheckedReservation;
import org.apache.solr.analytics.stream.reservation.FloatCheckedReservation;
import org.apache.solr.analytics.stream.reservation.IntCheckedReservation;
import org.apache.solr.analytics.stream.reservation.LongCheckedReservation;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;
import org.apache.solr.analytics.stream.reservation.StringCheckedReservation;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValueStream;

public abstract class MinCollector<T extends ReductionData>
extends ReductionDataCollector<T> {
    public static final String name = "min";
    private final String exprStr;
    private boolean exists;

    protected MinCollector(AnalyticsValueStream param) {
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param);
    }

    public boolean exists() {
        return this.exists;
    }

    @Override
    public void setMergedData(ReductionData data) {
        this.exists = data.exists;
    }

    @Override
    public void setData(ReductionData data) {
        this.exists = data.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    public static class StringMinCollector
    extends MinCollector<MinData> {
        private StringValueStream param;
        String min;
        String tempMin;
        boolean tempExists;

        public StringMinCollector(StringValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MinData newData() {
            MinData data = new MinData();
            data.exists = false;
            return data;
        }

        public String min() {
            return this.min;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamStrings(val -> {
                if (!this.tempExists || val.compareTo(this.tempMin) < 0) {
                    this.tempMin = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MinData data) {
            if (this.tempExists && (!data.exists || this.tempMin.compareTo(data.val) < 0)) {
                data.val = this.tempMin;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new StringCheckedReservation(value -> {
                if (!((MinData)this.ioData).exists || value.compareTo(((MinData)this.ioData).val) < 0) {
                    ((MinData)this.ioData).val = value;
                    ((MinData)this.ioData).exists = true;
                }
            }, () -> ((MinData)this.ioData).val, () -> ((MinData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        public static class MinData
        extends ReductionData {
            String val;
        }
    }

    public static class DoubleMinCollector
    extends MinCollector<MinData> {
        private DoubleValueStream param;
        double min;
        double tempMin;
        boolean tempExists;

        public DoubleMinCollector(DoubleValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MinData newData() {
            MinData data = new MinData();
            data.exists = false;
            return data;
        }

        public double min() {
            return this.min;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamDoubles(val -> {
                if (!this.tempExists || val < this.tempMin) {
                    this.tempMin = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MinData data) {
            if (this.tempExists && (!data.exists || this.tempMin < data.val)) {
                data.val = this.tempMin;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new DoubleCheckedReservation(value -> {
                if (!((MinData)this.ioData).exists || value < ((MinData)this.ioData).val) {
                    ((MinData)this.ioData).val = value;
                    ((MinData)this.ioData).exists = true;
                }
            }, () -> ((MinData)this.ioData).val, () -> ((MinData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        public static class MinData
        extends ReductionData {
            double val;
        }
    }

    public static class FloatMinCollector
    extends MinCollector<MinData> {
        private FloatValueStream param;
        float min;
        float tempMin;
        boolean tempExists;

        public FloatMinCollector(FloatValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MinData newData() {
            MinData data = new MinData();
            data.exists = false;
            return data;
        }

        public float min() {
            return this.min;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamFloats(val -> {
                if (!this.tempExists || val < this.tempMin) {
                    this.tempMin = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MinData data) {
            if (this.tempExists && (!data.exists || this.tempMin < data.val)) {
                data.val = this.tempMin;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new FloatCheckedReservation(value -> {
                if (!((MinData)this.ioData).exists || value < ((MinData)this.ioData).val) {
                    ((MinData)this.ioData).val = value;
                    ((MinData)this.ioData).exists = true;
                }
            }, () -> ((MinData)this.ioData).val, () -> ((MinData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        public static class MinData
        extends ReductionData {
            float val;
        }
    }

    public static class LongMinCollector
    extends MinCollector<MinData> {
        private LongValueStream param;
        long min;
        long tempMin;
        boolean tempExists;

        public LongMinCollector(LongValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MinData newData() {
            MinData data = new MinData();
            data.exists = false;
            return data;
        }

        public long min() {
            return this.min;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamLongs(val -> {
                if (!this.tempExists || val < this.tempMin) {
                    this.tempMin = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MinData data) {
            if (this.tempExists && (!data.exists || this.tempMin < data.val)) {
                data.val = this.tempMin;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new LongCheckedReservation(value -> {
                if (!((MinData)this.ioData).exists || value < ((MinData)this.ioData).val) {
                    ((MinData)this.ioData).val = value;
                    ((MinData)this.ioData).exists = true;
                }
            }, () -> ((MinData)this.ioData).val, () -> ((MinData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        public static class MinData
        extends ReductionData {
            long val;
        }
    }

    public static class IntMinCollector
    extends MinCollector<MinData> {
        private IntValueStream param;
        int min;
        int tempMin;
        boolean tempExists;

        public IntMinCollector(IntValueStream param) {
            super(param);
            this.param = param;
        }

        @Override
        public MinData newData() {
            MinData data = new MinData();
            data.exists = false;
            return data;
        }

        public int min() {
            return this.min;
        }

        @Override
        public void collect() {
            this.tempExists = false;
            this.param.streamInts(val -> {
                if (!this.tempExists || val < this.tempMin) {
                    this.tempMin = val;
                    this.tempExists = true;
                }
            });
        }

        @Override
        protected void apply(MinData data) {
            if (this.tempExists && (!data.exists || this.tempMin < data.val)) {
                data.val = this.tempMin;
                data.exists = true;
            }
        }

        @Override
        public void submitReservations(Consumer<ReductionDataReservation<?, ?>> consumer) {
            consumer.accept(new IntCheckedReservation(value -> {
                if (!((MinData)this.ioData).exists || value < ((MinData)this.ioData).val) {
                    ((MinData)this.ioData).val = value;
                    ((MinData)this.ioData).exists = true;
                }
            }, () -> ((MinData)this.ioData).val, () -> ((MinData)this.ioData).exists));
        }

        @Override
        public void setMergedData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        @Override
        public void setData(ReductionData data) {
            super.setData(data);
            this.min = ((MinData)data).val;
        }

        public static class MinData
        extends ReductionData {
            int val;
        }
    }
}

