/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;

public final class SlowCompositeReaderWrapper
extends LeafReader {
    private final CompositeReader in;
    private final LeafMetaData metaData;
    private final FieldInfos fieldInfos;
    final Map<String, Terms> cachedTerms = new ConcurrentHashMap<String, Terms>();
    final Map<String, OrdinalMap> cachedOrdMaps = new ConcurrentHashMap<String, OrdinalMap>();

    public static LeafReader wrap(IndexReader reader) throws IOException {
        if (reader instanceof CompositeReader) {
            return new SlowCompositeReaderWrapper((CompositeReader)reader);
        }
        assert (reader instanceof LeafReader);
        return (LeafReader)reader;
    }

    SlowCompositeReaderWrapper(CompositeReader reader) throws IOException {
        this.in = reader;
        this.in.registerParentReader((IndexReader)this);
        if (reader.leaves().isEmpty()) {
            this.metaData = new LeafMetaData(Version.LATEST.major, Version.LATEST, null);
        } else {
            Version minVersion = Version.LATEST;
            for (LeafReaderContext leafReaderContext : reader.leaves()) {
                Version leafVersion = leafReaderContext.reader().getMetaData().getMinVersion();
                if (leafVersion == null) {
                    minVersion = null;
                    break;
                }
                if (!minVersion.onOrAfter(leafVersion)) continue;
                minVersion = leafVersion;
            }
            int createdVersionMajor = ((LeafReaderContext)reader.leaves().get(0)).reader().getMetaData().getCreatedVersionMajor();
            this.metaData = new LeafMetaData(createdVersionMajor, minVersion, null);
        }
        this.fieldInfos = FieldInfos.getMergedFieldInfos((IndexReader)this.in);
    }

    public String toString() {
        return "SlowCompositeReaderWrapper(" + this.in + ")";
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        try {
            return this.cachedTerms.computeIfAbsent(field, f -> {
                try {
                    return MultiTerms.getTerms((IndexReader)this.in, (String)f);
                }
                catch (IOException e) {
                    throw new RuntimeException("unwrapMe", e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("unwrapMe") && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNumericValues((IndexReader)this.in, (String)field);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getBinaryValues((IndexReader)this.in, (String)field);
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getSortedNumericValues((IndexReader)this.in, (String)field);
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        List leaves = this.in.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return ((LeafReaderContext)leaves.get(0)).reader().getSortedDocValues(field);
        }
        boolean anyReal = false;
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = (LeafReaderContext)this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED) {
                return null;
            }
            SortedDocValues v = reader.getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            } else {
                anyReal = true;
            }
            totalCost += v.cost();
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap map = null;
        IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
        Function<String, OrdinalMap> producer = notUsed -> {
            try {
                OrdinalMap mapping = OrdinalMap.build((IndexReader.CacheKey)(cacheHelper == null ? null : cacheHelper.getKey()), (SortedDocValues[])values, (float)0.25f);
                return mapping;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        map = cacheHelper != null ? this.cachedOrdMaps.computeIfAbsent(field + cacheHelper.getKey(), producer) : producer.apply("notUsed");
        return new MultiDocValues.MultiSortedDocValues(values, starts, map, totalCost);
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        List leaves = this.in.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return ((LeafReaderContext)leaves.get(0)).reader().getSortedSetDocValues(field);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = (LeafReaderContext)this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED_SET) {
                return null;
            }
            SortedSetDocValues v = reader.getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            } else {
                anyReal = true;
            }
            totalCost += v.cost();
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap map = null;
        IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
        Function<String, OrdinalMap> producer = notUsed -> {
            try {
                OrdinalMap mapping = OrdinalMap.build((IndexReader.CacheKey)(cacheHelper == null ? null : cacheHelper.getKey()), (SortedSetDocValues[])values, (float)0.25f);
                return mapping;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        map = cacheHelper != null ? this.cachedOrdMaps.computeIfAbsent(field + cacheHelper.getKey(), producer) : producer.apply("notUsed");
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map, totalCost);
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNormValues((IndexReader)this.in, (String)field);
    }

    public Fields getTermVectors(int docID) throws IOException {
        return this.in.getTermVectors(docID);
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public int maxDoc() {
        return this.in.maxDoc();
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.document(docID, visitor);
    }

    public Bits getLiveDocs() {
        this.ensureOpen();
        return MultiBits.getLiveDocs((IndexReader)this.in);
    }

    public PointValues getPointValues(String field) {
        this.ensureOpen();
        return null;
    }

    public VectorValues getVectorValues(String field) {
        this.ensureOpen();
        return VectorValues.EMPTY;
    }

    public TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) throws IOException {
        return null;
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    protected void doClose() throws IOException {
        this.in.close();
    }

    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        for (LeafReaderContext ctx : this.in.leaves()) {
            ctx.reader().checkIntegrity();
        }
    }

    public LeafMetaData getMetaData() {
        return this.metaData;
    }
}

