/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/aliases")
public class ListAliasesAPI
extends AdminAPIBase {
    @Inject
    public ListAliasesAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    @Operation(summary="List the existing collection aliases.", tags={"aliases"})
    public ListAliasesResponse getAliases() throws Exception {
        ListAliasesAPI.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        ListAliasesResponse response = this.instantiateJerseyResponse(ListAliasesResponse.class);
        Aliases aliases = this.readAliasesFromZk();
        if (aliases != null) {
            response.aliases = aliases.getCollectionAliasMap();
            LinkedHashMap<String, Map<String, String>> meta = new LinkedHashMap<String, Map<String, String>>();
            for (String alias : aliases.getCollectionAliasListMap().keySet()) {
                Map collectionAliasProperties = aliases.getCollectionAliasProperties(alias);
                if (collectionAliasProperties.isEmpty()) continue;
                meta.put(alias, collectionAliasProperties);
            }
            response.properties = meta;
        }
        return response;
    }

    @GET
    @Path(value="/{aliasName}")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_READ_PERM)
    @Operation(summary="Get details for a specific collection alias.", tags={"aliases"})
    public GetAliasByNameResponse getAliasByName(@Parameter(description="Alias name.", required=true) @PathParam(value="aliasName") String aliasName) throws Exception {
        ListAliasesAPI.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        GetAliasByNameResponse response = this.instantiateJerseyResponse(GetAliasByNameResponse.class);
        response.alias = aliasName;
        Aliases aliases = this.readAliasesFromZk();
        if (aliases != null) {
            response.collections = aliases.getCollectionAliasListMap().getOrDefault(aliasName, List.of());
            response.properties = aliases.getCollectionAliasProperties(aliasName);
        }
        return response;
    }

    private Aliases readAliasesFromZk() throws Exception {
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkStateReader zkStateReader = coreContainer.getZkController().getZkStateReader();
        zkStateReader.getAliasesManager().update();
        return zkStateReader.getAliases();
    }

    public static class GetAliasByNameResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="name")
        public String alias;
        @JsonProperty(value="collections")
        public List<String> collections;
        @JsonProperty(value="properties")
        public Map<String, String> properties;
    }

    public static class ListAliasesResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="aliases")
        public Map<String, String> aliases;
        @JsonProperty(value="properties")
        public Map<String, Map<String, String>> properties;
    }
}

