/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="cluster/nodes/{nodeName}/clear/")
public class DeleteNodeAPI
extends AdminAPIBase {
    @Inject
    public DeleteNodeAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse deleteNode(@Parameter(description="The name of the node to be cleared.  Usually of the form 'host:1234_solr'.", required=true) @PathParam(value="nodeName") String nodeName, @RequestBody(description="Contains user provided parameters", required=true) DeleteNodeRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = DeleteNodeAPI.createRemoteMessage(nodeName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.DELETENODE, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public static SolrJerseyResponse invokeUsingV1Inputs(DeleteNodeAPI apiInstance, SolrParams params) throws Exception {
        RequiredSolrParams requiredParams = params.required();
        DeleteNodeRequestBody requestBody = new DeleteNodeRequestBody(params.get("async"));
        return apiInstance.deleteNode(requiredParams.get("node"), requestBody);
    }

    public static ZkNodeProps createRemoteMessage(String nodeName, DeleteNodeRequestBody requestBody) {
        HashMap<String, String> remoteMessage = new HashMap<String, String>();
        remoteMessage.put("node", nodeName);
        if (requestBody != null && requestBody.async != null) {
            remoteMessage.put("async", requestBody.async);
        }
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETENODE.toLower());
        return new ZkNodeProps(remoteMessage);
    }

    public static class DeleteNodeRequestBody
    implements JacksonReflectMapWriter {
        @Schema(description="Request ID to track this action which will be processed asynchronously.")
        @JsonProperty(value="async")
        public String async;

        public DeleteNodeRequestBody() {
        }

        public DeleteNodeRequestBody(String async) {
            this.async = async;
        }
    }
}

