/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.CancellableCollector;

public class CancellableQueryTracker {
    private final Map<String, Cancellable> activeCancellableQueries = new ConcurrentHashMap<String, Cancellable>();
    private final Map<String, String> activeQueriesGenerated = new ConcurrentHashMap<String, String>();

    public String generateQueryID(SolrQueryRequest req) {
        String customQueryUUID = req.getParams().get("queryUUID", null);
        String queryID = customQueryUUID != null ? customQueryUUID : UUID.randomUUID().toString();
        if (this.activeQueriesGenerated.containsKey(queryID)) {
            if (customQueryUUID != null) {
                throw new IllegalArgumentException("Duplicate query UUID given");
            }
            while (this.activeQueriesGenerated.get(queryID) != null) {
                queryID = UUID.randomUUID().toString();
            }
        }
        this.activeQueriesGenerated.put(queryID, req.getHttpSolrCall().getReq().getQueryString());
        return queryID;
    }

    public void releaseQueryID(String inputQueryID) {
        if (inputQueryID == null) {
            return;
        }
        this.activeQueriesGenerated.remove(inputQueryID);
    }

    public boolean isQueryIdActive(String queryID) {
        return this.activeQueriesGenerated.containsKey(queryID);
    }

    public void addShardLevelActiveQuery(String queryID, CancellableCollector collector) {
        if (queryID == null) {
            return;
        }
        this.activeCancellableQueries.put(queryID, collector);
    }

    public Cancellable getCancellableTask(String queryID) {
        if (queryID == null) {
            throw new IllegalArgumentException("Input queryID is null");
        }
        return this.activeCancellableQueries.get(queryID);
    }

    public void removeCancellableQuery(String queryID) {
        if (queryID == null) {
            return;
        }
        this.activeCancellableQueries.remove(queryID);
    }

    public Iterator<Map.Entry<String, String>> getActiveQueriesGenerated() {
        return this.activeQueriesGenerated.entrySet().iterator();
    }
}

