/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.LockTree;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.OcmhCollectionCommandContext;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.logging.MDCLoggingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionMessageHandler
implements OverseerMessageHandler,
SolrCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Overseer overseer;
    HttpShardHandlerFactory shardHandlerFactory;
    String adminPath;
    ZkStateReader zkStateReader;
    SolrCloudManager cloudManager;
    String myId;
    Stats stats;
    TimeSource timeSource;
    private final LockTree lockTree = new LockTree();
    ExecutorService tpe = new ExecutorUtil.MDCAwareThreadPoolExecutor(5, 10, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("OverseerCollectionMessageHandlerThreadFactory"));
    private final CollApiCmds.CommandMap commandMapper;
    private volatile boolean isClosed;
    private long sessionId = -1L;
    private LockTree.Session lockSession;

    public OverseerCollectionMessageHandler(ZkStateReader zkStateReader, String myId, HttpShardHandlerFactory shardHandlerFactory, String adminPath, Stats stats, Overseer overseer, OverseerNodePrioritizer overseerPrioritizer) {
        this.zkStateReader = zkStateReader;
        this.shardHandlerFactory = shardHandlerFactory;
        this.adminPath = adminPath;
        this.myId = myId;
        this.stats = stats;
        this.overseer = overseer;
        this.cloudManager = overseer.getSolrCloudManager();
        this.timeSource = this.cloudManager.getTimeSource();
        this.isClosed = false;
        this.commandMapper = new CollApiCmds.CommandMap(new OcmhCollectionCommandContext(this), overseerPrioritizer);
    }

    @Override
    public OverseerSolrResponse processMessage(ZkNodeProps message, String operation) {
        MDCLoggingContext.setCollection(message.getStr("collection"));
        MDCLoggingContext.setShard(message.getStr("shard"));
        MDCLoggingContext.setReplica(message.getStr("replica"));
        log.debug("OverseerCollectionMessageHandler.processMessage : {} , {}", (Object)operation, (Object)message);
        NamedList results = new NamedList();
        try {
            CollectionParams.CollectionAction action = this.getCollectionAction(operation);
            CollApiCmds.CollectionApiCommand command = this.commandMapper.getActionCommand(action);
            if (command == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            command.call(this.cloudManager.getClusterState(), message, (NamedList<Object>)results);
        }
        catch (Exception e) {
            String collName = message.getStr("collection");
            if (collName == null) {
                collName = message.getStr("name");
            }
            if (collName == null) {
                SolrException.log((Logger)log, (String)("Operation " + operation + " failed"), (Throwable)e);
            } else {
                SolrException.log((Logger)log, (String)("Collection: " + collName + " operation: " + operation + " failed"), (Throwable)e);
            }
            results.add("Operation " + operation + " caused exception:", (Object)e);
            SimpleOrderedMap nl = new SimpleOrderedMap();
            nl.add("msg", (Object)e.getMessage());
            nl.add("rspCode", (Object)(e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1));
            results.add("exception", (Object)nl);
        }
        return new OverseerSolrResponse((NamedList<Object>)results);
    }

    private CollectionParams.CollectionAction getCollectionAction(String operation) {
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)operation);
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
        }
        return action;
    }

    @Override
    public String getName() {
        return "Overseer Collection Message Handler";
    }

    @Override
    public String getTimerName(String operation) {
        return "collection_" + operation;
    }

    @Override
    public String getTaskKey(ZkNodeProps message) {
        return message.containsKey("collection") ? message.getStr("collection") : message.getStr("name");
    }

    @Override
    public OverseerMessageHandler.Lock lockTask(ZkNodeProps message, long batchSessionId) {
        if (this.sessionId != batchSessionId) {
            this.lockSession = this.lockTree.getSession();
            this.sessionId = batchSessionId;
        }
        return this.lockSession.lock(this.getCollectionAction(message.getStr("operation")), Arrays.asList(this.getTaskKey(message), message.getStr("shard"), message.getStr("replica")));
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.tpe != null && !ExecutorUtil.isShutdown((ExecutorService)this.tpe)) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.tpe);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

