/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.OpenNLPTokenizer;
import org.apache.lucene.analysis.opennlp.tools.NLPChunkerOp;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="other filters must precede this one (see docs)")
public final class OpenNLPChunkerFilter
extends TokenFilter {
    private List<AttributeSource> sentenceTokenAttrs = new ArrayList<AttributeSource>();
    private int tokenNum = 0;
    private boolean moreTokensAvailable = true;
    private String[] sentenceTerms = null;
    private String[] sentenceTermPOSTags = null;
    private final NLPChunkerOp chunkerOp;
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public OpenNLPChunkerFilter(TokenStream input, NLPChunkerOp chunkerOp) {
        super(input);
        this.chunkerOp = chunkerOp;
    }

    public final boolean incrementToken() throws IOException {
        if (!this.moreTokensAvailable) {
            this.clear();
            return false;
        }
        if (this.tokenNum == this.sentenceTokenAttrs.size()) {
            this.nextSentence();
            if (this.sentenceTerms == null) {
                this.clear();
                return false;
            }
            this.assignTokenTypes(this.chunkerOp.getChunks(this.sentenceTerms, this.sentenceTermPOSTags, null));
            this.tokenNum = 0;
        }
        this.clearAttributes();
        this.sentenceTokenAttrs.get(this.tokenNum++).copyTo((AttributeSource)this);
        return true;
    }

    private void nextSentence() throws IOException {
        ArrayList<String> termList = new ArrayList<String>();
        ArrayList<String> posTagList = new ArrayList<String>();
        this.sentenceTokenAttrs.clear();
        boolean endOfSentence = false;
        while (!endOfSentence && (this.moreTokensAvailable = this.input.incrementToken())) {
            termList.add(this.termAtt.toString());
            posTagList.add(this.typeAtt.type());
            endOfSentence = 0 != (this.flagsAtt.getFlags() & OpenNLPTokenizer.EOS_FLAG_BIT);
            this.sentenceTokenAttrs.add(this.input.cloneAttributes());
        }
        this.sentenceTerms = termList.size() > 0 ? termList.toArray(new String[termList.size()]) : null;
        this.sentenceTermPOSTags = posTagList.size() > 0 ? posTagList.toArray(new String[posTagList.size()]) : null;
    }

    private void assignTokenTypes(String[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            ((TypeAttribute)this.sentenceTokenAttrs.get(i).getAttribute(TypeAttribute.class)).setType(tags[i]);
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.moreTokensAvailable = true;
        this.clear();
    }

    private void clear() {
        this.sentenceTokenAttrs.clear();
        this.sentenceTerms = null;
        this.sentenceTermPOSTags = null;
        this.tokenNum = 0;
    }
}

