/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.response.transform;

import java.io.IOException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.ltr.SolrQueryRequestContextUtils;
import org.apache.solr.ltr.interleaving.LTRInterleavingScoringQuery;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.util.SolrPluginUtils;

public class LTRInterleavingTransformerFactory
extends TransformerFactory {
    public void init(NamedList<?> args) {
        super.init(args);
        SolrPluginUtils.invokeSetters((Object)((Object)this), args);
    }

    public DocTransformer create(String name, SolrParams localparams, SolrQueryRequest req) {
        return new InterleavingTransformer(name, req);
    }

    static class InterleavingTransformer
    extends DocTransformer {
        private final String name;
        private final SolrQueryRequest req;
        private LTRInterleavingScoringQuery[] rerankingQueries;

        public InterleavingTransformer(String name, SolrQueryRequest req) {
            this.name = name;
            this.req = req;
        }

        public String getName() {
            return this.name;
        }

        public void setContext(ResultContext context) {
            super.setContext(context);
            if (context == null) {
                return;
            }
            if (context.getRequest() == null) {
                return;
            }
            this.rerankingQueries = (LTRInterleavingScoringQuery[])SolrQueryRequestContextUtils.getScoringQueries(this.req);
            for (int i = 0; i < this.rerankingQueries.length; ++i) {
                LTRInterleavingScoringQuery scoringQuery = this.rerankingQueries[i];
                if (scoringQuery.getOriginalQuery() == null) {
                    scoringQuery.setOriginalQuery(context.getQuery());
                }
                if (scoringQuery.getFeatureLogger() == null) {
                    scoringQuery.setFeatureLogger(SolrQueryRequestContextUtils.getFeatureLogger(this.req));
                }
                scoringQuery.setRequest(this.req);
            }
        }

        public void transform(SolrDocument doc, int docid, float score) throws IOException {
            this.implTransform(doc, docid);
        }

        public void transform(SolrDocument doc, int docid) throws IOException {
            this.implTransform(doc, docid);
        }

        private void implTransform(SolrDocument doc, int docid) {
            LTRInterleavingScoringQuery rerankingQuery = this.rerankingQueries[0];
            if (this.rerankingQueries.length > 1 && this.rerankingQueries[1].getPickedInterleavingDocIds().contains(docid)) {
                rerankingQuery = this.rerankingQueries[1];
            }
            doc.addField(this.name, (Object)rerankingQuery.getScoringModelName());
        }
    }
}

