
'''Plugin package

This package must be imported with the 'from ... import *' syntax.

Plugins must import the register* methods from the remote module in
order to be able to register classes and parameters.

In addition to the modules physically contained in this packages
it also loads modules from the users plugin directory.'''


import os
from lekatnet.config import _user_plugin_dir

# extend the packages scope to the users plugin directory
__path__.append(_user_plugin_dir)

def __importPlugins():
	p = []
	for path in _user_plugin_dir, os.path.dirname(__file__):
		if os.path.exists(path):
			files = os.listdir(path)
			p += [ x[:-3] for x in files if x[-3:] == '.py' and not x == '__init__.py' ]
	return p

__all__ = __importPlugins()
