/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.DateMathStreamFunction;
import org.apache.solr.analytics.function.mapping.DateMathValueFunction;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.analytics.value.constant.ConstantValue;
import org.apache.solr.common.SolrException;

public class DateMathFunction {
    public static final String name = "date_math";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length < 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date_math function requires at least 2 paramaters, " + params.length + " found.");
        }
        StringBuilder mathParam = new StringBuilder();
        for (int i = 1; i < params.length; ++i) {
            if (!(params[i] instanceof StringValue) || !(params[i] instanceof ConstantValue)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date_math function requires all math parameters to be a constant strings.");
            }
            mathParam.append(((StringValue)params[i]).getString());
        }
        if (params[0] instanceof DateValue) {
            return new DateMathValueFunction((DateValue)params[0], new ConstantStringValue(mathParam.toString()));
        }
        if (params[0] instanceof DateValueStream) {
            return new DateMathStreamFunction((DateValueStream)params[0], new ConstantStringValue(mathParam.toString()));
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date_math function requires a date as the first parameter.");
    };
}

