/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hslf.blip.DIB;
import org.apache.poi.hslf.blip.EMF;
import org.apache.poi.hslf.blip.JPEG;
import org.apache.poi.hslf.blip.PICT;
import org.apache.poi.hslf.blip.PNG;
import org.apache.poi.hslf.blip.WMF;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public abstract class HSLFPictureData
implements PictureData,
GenericRecord {
    protected static final int CHECKSUM_SIZE = 16;
    private byte[] rawdata;
    private int offset;
    private int uidInstanceCount = 1;
    private int index = -1;

    protected abstract int getSignature();

    public abstract void setSignature(int var1);

    protected int getUIDInstanceCount() {
        return this.uidInstanceCount;
    }

    protected void setUIDInstanceCount(int uidInstanceCount) {
        this.uidInstanceCount = uidInstanceCount;
    }

    public byte[] getRawData() {
        return this.rawdata;
    }

    public void setRawData(byte[] data) {
        this.rawdata = data == null ? null : (byte[])data.clone();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getUID() {
        byte[] uid = new byte[16];
        System.arraycopy(this.rawdata, 0, uid, 0, uid.length);
        return uid;
    }

    public byte[] getChecksum() {
        return HSLFPictureData.getChecksum(this.getData());
    }

    public static byte[] getChecksum(byte[] data) {
        MessageDigest md5 = CryptoFunctions.getMessageDigest((HashAlgorithm)HashAlgorithm.md5);
        md5.update(data);
        return md5.digest();
    }

    public void write(OutputStream out) throws IOException {
        byte[] data = new byte[2];
        LittleEndian.putUShort((byte[])data, (int)0, (int)this.getSignature());
        out.write(data);
        data = new byte[2];
        PictureData.PictureType pt = this.getType();
        LittleEndian.putUShort((byte[])data, (int)0, (int)(pt.nativeId + 61464));
        out.write(data);
        byte[] rd = this.getRawData();
        data = new byte[4];
        LittleEndian.putInt((byte[])data, (int)0, (int)rd.length);
        out.write(data);
        out.write(rd);
    }

    public static HSLFPictureData create(PictureData.PictureType type) {
        HSLFPictureData pict;
        switch (type) {
            case EMF: {
                pict = new EMF();
                break;
            }
            case WMF: {
                pict = new WMF();
                break;
            }
            case PICT: {
                pict = new PICT();
                break;
            }
            case JPEG: {
                pict = new JPEG();
                break;
            }
            case PNG: {
                pict = new PNG();
                break;
            }
            case DIB: {
                pict = new DIB();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported picture type: " + type);
            }
        }
        return pict;
    }

    public byte[] getHeader() {
        byte[] header = new byte[24];
        LittleEndian.putInt((byte[])header, (int)0, (int)this.getSignature());
        LittleEndian.putInt((byte[])header, (int)4, (int)this.getRawData().length);
        System.arraycopy(this.rawdata, 0, header, 8, 16);
        return header;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public final String getContentType() {
        return this.getType().contentType;
    }

    public Dimension getImageDimensionInPixels() {
        Dimension dim = this.getImageDimension();
        return new Dimension(Units.pointsToPixel((double)dim.getWidth()), Units.pointsToPixel((double)dim.getHeight()));
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        LinkedHashMap<String, Supplier<Object>> m = new LinkedHashMap<String, Supplier<Object>>();
        m.put("type", () -> ((HSLFPictureData)this).getType());
        m.put("imageDimension", () -> ((HSLFPictureData)this).getImageDimension());
        m.put("signature", this::getSignature);
        m.put("uidInstanceCount", this::getUIDInstanceCount);
        m.put("offset", this::getOffset);
        m.put("uid", this::getUID);
        m.put("checksum", this::getChecksum);
        m.put("index", this::getIndex);
        m.put("rawData", this::getRawData);
        return Collections.unmodifiableMap(m);
    }
}

