# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class DBRPsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """DBRPsService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def delete_dbrpid(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a database retention policy.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dbrpid(dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dbrpid_with_http_info(dbrp_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dbrpid_with_http_info(dbrp_id, **kwargs)  # noqa: E501
            return data

    def delete_dbrpid_with_http_info(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a database retention policy.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dbrpid_with_http_info(dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dbrpid_prepare(dbrp_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_dbrpid_async(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a database retention policy.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_dbrpid_prepare(dbrp_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_dbrpid_prepare(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dbrp_id', 'zap_trace_span', 'org_id', 'org']  # noqa: E501
        self._check_operation_params('delete_dbrpid', all_params, local_var_params)
        # verify the required parameter 'dbrp_id' is set
        if ('dbrp_id' not in local_var_params or
                local_var_params['dbrp_id'] is None):
            raise ValueError("Missing the required parameter `dbrp_id` when calling `delete_dbrpid`")  # noqa: E501

        path_params = {}
        if 'dbrp_id' in local_var_params:
            path_params['dbrpID'] = local_var_params['dbrp_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dbr_ps(self, **kwargs):  # noqa: E501,D401,D403
        """List database retention policy mappings.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID to filter on
        :param str org: Specifies the organization name to filter on
        :param str id: Specifies the mapping ID to filter on
        :param str bucket_id: Specifies the bucket ID to filter on
        :param bool default: Specifies filtering on default
        :param str db: Specifies the database to filter on
        :param str rp: Specifies the retention policy to filter on
        :return: DBRPs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dbr_ps_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dbr_ps_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dbr_ps_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List database retention policy mappings.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID to filter on
        :param str org: Specifies the organization name to filter on
        :param str id: Specifies the mapping ID to filter on
        :param str bucket_id: Specifies the bucket ID to filter on
        :param bool default: Specifies filtering on default
        :param str db: Specifies the database to filter on
        :param str rp: Specifies the retention policy to filter on
        :return: DBRPs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dbr_ps_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/dbrps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRPs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dbr_ps_async(self, **kwargs):  # noqa: E501,D401,D403
        """List database retention policy mappings.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID to filter on
        :param str org: Specifies the organization name to filter on
        :param str id: Specifies the mapping ID to filter on
        :param str bucket_id: Specifies the bucket ID to filter on
        :param bool default: Specifies filtering on default
        :param str db: Specifies the database to filter on
        :param str rp: Specifies the retention policy to filter on
        :return: DBRPs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dbr_ps_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/dbrps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRPs',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dbr_ps_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'org_id', 'org', 'id', 'bucket_id', 'default', 'db', 'rp']  # noqa: E501
        self._check_operation_params('get_dbr_ps', all_params, local_var_params)

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'bucket_id' in local_var_params:
            query_params.append(('bucketID', local_var_params['bucket_id']))  # noqa: E501
        if 'default' in local_var_params:
            query_params.append(('default', local_var_params['default']))  # noqa: E501
        if 'db' in local_var_params:
            query_params.append(('db', local_var_params['db']))  # noqa: E501
        if 'rp' in local_var_params:
            query_params.append(('rp', local_var_params['rp']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_dbr_ps_id(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps_id(dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping ID (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: DBRPGet
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dbr_ps_id_with_http_info(dbrp_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dbr_ps_id_with_http_info(dbrp_id, **kwargs)  # noqa: E501
            return data

    def get_dbr_ps_id_with_http_info(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps_id_with_http_info(dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping ID (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: DBRPGet
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dbr_ps_id_prepare(dbrp_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRPGet',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_dbr_ps_id_async(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a database retention policy mapping.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping ID (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: DBRPGet
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_dbr_ps_id_prepare(dbrp_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRPGet',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_dbr_ps_id_prepare(self, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dbrp_id', 'zap_trace_span', 'org_id', 'org']  # noqa: E501
        self._check_operation_params('get_dbr_ps_id', all_params, local_var_params)
        # verify the required parameter 'dbrp_id' is set
        if ('dbrp_id' not in local_var_params or
                local_var_params['dbrp_id'] is None):
            raise ValueError("Missing the required parameter `dbrp_id` when calling `get_dbr_ps_id`")  # noqa: E501

        path_params = {}
        if 'dbrp_id' in local_var_params:
            path_params['dbrpID'] = local_var_params['dbrp_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_dbrpid(self, dbrp_id, dbrp_update, **kwargs):  # noqa: E501,D401,D403
        """Update a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dbrpid(dbrp_id, dbrp_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping. (required)
        :param DBRPUpdate dbrp_update: Database retention policy update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: DBRPGet
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_dbrpid_with_http_info(dbrp_id, dbrp_update, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_dbrpid_with_http_info(dbrp_id, dbrp_update, **kwargs)  # noqa: E501
            return data

    def patch_dbrpid_with_http_info(self, dbrp_id, dbrp_update, **kwargs):  # noqa: E501,D401,D403
        """Update a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dbrpid_with_http_info(dbrp_id, dbrp_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping. (required)
        :param DBRPUpdate dbrp_update: Database retention policy update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: DBRPGet
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dbrpid_prepare(dbrp_id, dbrp_update, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRPGet',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_dbrpid_async(self, dbrp_id, dbrp_update, **kwargs):  # noqa: E501,D401,D403
        """Update a database retention policy mapping.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str dbrp_id: The database retention policy mapping. (required)
        :param DBRPUpdate dbrp_update: Database retention policy update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org_id: Specifies the organization ID of the mapping
        :param str org: Specifies the organization name of the mapping
        :return: DBRPGet
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_dbrpid_prepare(dbrp_id, dbrp_update, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRPGet',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_dbrpid_prepare(self, dbrp_id, dbrp_update, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dbrp_id', 'dbrp_update', 'zap_trace_span', 'org_id', 'org']  # noqa: E501
        self._check_operation_params('patch_dbrpid', all_params, local_var_params)
        # verify the required parameter 'dbrp_id' is set
        if ('dbrp_id' not in local_var_params or
                local_var_params['dbrp_id'] is None):
            raise ValueError("Missing the required parameter `dbrp_id` when calling `patch_dbrpid`")  # noqa: E501
        # verify the required parameter 'dbrp_update' is set
        if ('dbrp_update' not in local_var_params or
                local_var_params['dbrp_update'] is None):
            raise ValueError("Missing the required parameter `dbrp_update` when calling `patch_dbrpid`")  # noqa: E501

        path_params = {}
        if 'dbrp_id' in local_var_params:
            path_params['dbrpID'] = local_var_params['dbrp_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'dbrp_update' in local_var_params:
            body_params = local_var_params['dbrp_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_dbrp(self, dbrp_create, **kwargs):  # noqa: E501,D401,D403
        """Add a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dbrp(dbrp_create, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DBRPCreate dbrp_create: The database retention policy mapping to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dbrp_with_http_info(dbrp_create, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dbrp_with_http_info(dbrp_create, **kwargs)  # noqa: E501
            return data

    def post_dbrp_with_http_info(self, dbrp_create, **kwargs):  # noqa: E501,D401,D403
        """Add a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dbrp_with_http_info(dbrp_create, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DBRPCreate dbrp_create: The database retention policy mapping to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dbrp_prepare(dbrp_create, **kwargs)

        return self.api_client.call_api(
            '/api/v2/dbrps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRP',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_dbrp_async(self, dbrp_create, **kwargs):  # noqa: E501,D401,D403
        """Add a database retention policy mapping.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param DBRPCreate dbrp_create: The database retention policy mapping to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_dbrp_prepare(dbrp_create, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/dbrps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='DBRP',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_dbrp_prepare(self, dbrp_create, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['dbrp_create', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_dbrp', all_params, local_var_params)
        # verify the required parameter 'dbrp_create' is set
        if ('dbrp_create' not in local_var_params or
                local_var_params['dbrp_create'] is None):
            raise ValueError("Missing the required parameter `dbrp_create` when calling `post_dbrp`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'dbrp_create' in local_var_params:
            body_params = local_var_params['dbrp_create']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
