%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}





% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/home/gub/NewGub/gub/target/linux-x86/src/lilypond-git.sv.gnu.org--lilypond.git-stable-2.22/input/regression/midi-after-writing.ly"
\sourcefileline 0
\version "2.21.1"

\header {
  texidoc = "If @code{after-writing} is set in the @code{\\midi}
block, it is called after every MIDI file that is written.  The
visual and MIDI output are not important in this test."

  AA = "a0"
  EE = "e0"
}

#(ly:set-option 'warning-as-error #t)

\midi {
  after-writing =
  #(lambda (performance file-name)
    (let* ((headers (ly:performance-headers performance))
           (AA (ly:modules-lookup headers 'AA))
           (BB (ly:modules-lookup headers 'BB))
           (CC (ly:modules-lookup headers 'CC))
           (DD (ly:modules-lookup headers 'DD))
           (EE (ly:modules-lookup headers 'EE))
           (FF (ly:modules-lookup headers 'FF))
           (GG (ly:modules-lookup headers 'GG)))
     (ly:warning "~a ~a ~a ~a ~a ~a ~a" AA BB CC DD EE FF GG)))
}

\book {
  \header { BB = "b1" EE = "e1" FF = "f1" }
  \bookpart {
    \header { CC = "c2" FF = "f2" GG = "g2" }

    %% this score tests that variables can be introduced (A-D) and
    %% overridden (E-G)
    #(ly:expect-warning "a0 b1 c2 d3 e1 f2 g3")
    \score {
      { c'1 }
      \header { DD = "d3" GG = "g3" }
      \layout { }
      \midi { }
    }
  }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
