/*
 * Decompiled with CFR 0.152.
 */
package clojure.tools.deps.alpha.util;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.NoTransporterException;

@Named(value="s3")
public final class S3TransporterFactory
implements TransporterFactory,
Service {
    private S3TransporterFactory() {
    }

    @Override
    public void initService(ServiceLocator locator) {
    }

    @Override
    public Transporter newInstance(RepositorySystemSession session2, RemoteRepository repository) throws NoTransporterException {
        String protocol = repository.getProtocol();
        if ("s3".equals(protocol)) {
            return (Transporter)DelayedInstance.NEW_TRANSPORTER.invoke(session2, repository);
        }
        throw new NoTransporterException(repository);
    }

    @Override
    public float getPriority() {
        return 5.0f;
    }

    private static class DelayedInstance {
        private static final IFn NEW_TRANSPORTER;

        private DelayedInstance() {
        }

        static {
            IFn REQUIRE = Clojure.var("clojure.core", "require");
            REQUIRE.invoke(Clojure.read("clojure.tools.deps.alpha.util.s3-transporter"));
            NEW_TRANSPORTER = Clojure.var("clojure.tools.deps.alpha.util.s3-transporter", "new-transporter");
        }
    }
}

