from pycaption.scc.constants import CHARACTERS, SPECIAL_CHARS, EXTENDED_CHARS

ALL_CHARACTERS = {**CHARACTERS, **SPECIAL_CHARS, **EXTENDED_CHARS}
COMMAND_LABELS = {
    "9420": "Resume Caption Loading",
    "9429": "Resume Direct Captioning",
    "9425": "Roll-Up Captions--2 Rows",
    "9426": "Roll-Up Captions--3 Rows",
    "94a7": "Roll-Up Captions--4 Rows",
    "942a": "Text Restart",
    "94ab": "Resume Text Display",
    "942c": "Erase Displayed Memory",
    "94ae": "Erase Non-displayed Memory",
    "942f": "End Of Caption",
    "9140": "row 01, column 00, with plain white text.",
    "91c1": "row 01, column 00, with white underlined text.",
    "91c2": "row 01, column 00, with plain green text.",
    "9143": "row 01, column 00, with green underlined text.",
    "91c4": "row 01, column 00, with plain blue text.",
    "9145": "row 01, column 00, with blue underlined text.",
    "9146": "row 01, column 00, with plain cyan text.",
    "91c7": "row 01, column 00, with cyan underlined text.",
    "91c8": "row 01, column 00, with plain red text.",
    "9149": "row 01, column 00, with red underlined text.",
    "914a": "row 01, column 00, with plain yellow text.",
    "91cb": "row 01, column 00, with yellow underlined text.",
    "914c": "row 01, column 00, with plain magenta text.",
    "91cd": "row 01, column 00, with magenta underlined text.",
    "91ce": "row 01, column 00, with white italicized text.",
    "914f": "row 01, column 00, with white underlined italicized text.",
    "91d0": "row 01, column 00, with plain white text.",
    "9151": "row 01, column 00, with white underlined text.",
    "9152": "row 01, column 04, with plain white text.",
    "91d3": "row 01, column 04, with white underlined text.",
    "9154": "row 01, column 08, with plain white text.",
    "91d5": "row 01, column 08, with white underlined text.",
    "91d6": "row 01, column 12, with plain white text.",
    "9157": "row 01, column 12, with white underlined text.",
    "9158": "row 01, column 16, with plain white text.",
    "91d9": "row 01, column 16, with white underlined text.",
    "91da": "row 01, column 20, with plain white text.",
    "915b": "row 01, column 20, with white underlined text.",
    "91dc": "row 01, column 24, with plain white text.",
    "915d": "row 01, column 24, with white underlined text.",
    "915e": "row 01, column 28, with plain white text.",
    "91df": "row 01, column 28, with white underlined text.",
    "91e0": "row 02, column 00, with plain white text.",
    "9161": "row 02, column 00, with white underlined text.",
    "9162": "row 02, column 00, with plain green text.",
    "91e3": "row 02, column 00, with green underlined text.",
    "9164": "row 02, column 00, with plain blue text.",
    "91e5": "row 02, column 00, with blue underlined text.",
    "91e6": "row 02, column 00, with plain cyan text.",
    "9167": "row 02, column 00, with cyan underlined text.",
    "9168": "row 02, column 00, with plain red text.",
    "91e9": "row 02, column 00, with red underlined text.",
    "91ea": "row 02, column 00, with plain yellow text.",
    "916b": "row 02, column 00, with yellow underlined text.",
    "91ec": "row 02, column 00, with plain magenta text.",
    "916d": "row 02, column 00, with magenta underlined text.",
    "916e": "row 02, column 00, with white italicized text.",
    "91ef": "row 02, column 00, with white underlined italicized text.",
    "9170": "row 02, column 00, with plain white text.",
    "91f1": "row 02, column 00, with white underlined text.",
    "91f2": "row 02, column 04, with plain white text.",
    "9173": "row 02, column 04, with white underlined text.",
    "91f4": "row 02, column 08, with plain white text.",
    "9175": "row 02, column 08, with white underlined text.",
    "9176": "row 02, column 12, with plain white text.",
    "91f7": "row 02, column 12, with white underlined text.",
    "91f8": "row 02, column 16, with plain white text.",
    "9179": "row 02, column 16, with white underlined text.",
    "917a": "row 02, column 20, with plain white text.",
    "91fb": "row 02, column 20, with white underlined text.",
    "91fc": "row 02, column 24, with plain white text.",
    "91fd": "row 02, column 24, with white underlined text.",
    "91fe": "row 02, column 28, with plain white text.",
    "917f": "row 02, column 28, with white underlined text.",
    "9240": "row 03, column 00, with plain white text.",
    "92c1": "row 03, column 00, with white underlined text.",
    "92c2": "row 03, column 00, with plain green text.",
    "9243": "row 03, column 00, with green underlined text.",
    "92c4": "row 03, column 00, with plain blue text.",
    "9245": "row 03, column 00, with blue underlined text.",
    "9246": "row 03, column 00, with plain cyan text.",
    "92c7": "row 03, column 00, with cyan underlined text.",
    "92c8": "row 03, column 00, with plain red text.",
    "9249": "row 03, column 00, with red underlined text.",
    "924a": "row 03, column 00, with plain yellow text.",
    "92cb": "row 03, column 00, with yellow underlined text.",
    "924c": "row 03, column 00, with plain magenta text.",
    "92cd": "row 03, column 00, with magenta underlined text.",
    "92ce": "row 03, column 00, with white italicized text.",
    "924f": "row 03, column 00, with white underlined italicized text.",
    "92d0": "row 03, column 00, with plain white text.",
    "9251": "row 03, column 00, with white underlined text.",
    "9252": "row 03, column 04, with plain white text.",
    "92d3": "row 03, column 04, with white underlined text.",
    "9254": "row 03, column 08, with plain white text.",
    "92d5": "row 03, column 08, with white underlined text.",
    "92d6": "row 03, column 12, with plain white text.",
    "9257": "row 03, column 12, with white underlined text.",
    "9258": "row 03, column 16, with plain white text.",
    "92d9": "row 03, column 16, with white underlined text.",
    "92da": "row 03, column 20, with plain white text.",
    "925b": "row 03, column 20, with white underlined text.",
    "92dc": "row 03, column 24, with plain white text.",
    "925d": "row 03, column 24, with white underlined text.",
    "925e": "row 03, column 28, with plain white text.",
    "92df": "row 03, column 28, with white underlined text.",
    "92e0": "row 04, column 00, with plain white text.",
    "9261": "row 04, column 00, with white underlined text.",
    "9262": "row 04, column 00, with plain green text.",
    "92e3": "row 04, column 00, with green underlined text.",
    "9264": "row 04, column 00, with plain blue text.",
    "92e5": "row 04, column 00, with blue underlined text.",
    "92e6": "row 04, column 00, with plain cyan text.",
    "9267": "row 04, column 00, with cyan underlined text.",
    "9268": "row 04, column 00, with plain red text.",
    "92e9": "row 04, column 00, with red underlined text.",
    "92ea": "row 04, column 00, with plain yellow text.",
    "926b": "row 04, column 00, with yellow underlined text.",
    "92ec": "row 04, column 00, with plain magenta text.",
    "926d": "row 04, column 00, with magenta underlined text.",
    "926e": "row 04, column 00, with white italicized text.",
    "92ef": "row 04, column 00, with white underlined italicized text.",
    "9270": "row 04, column 00, with plain white text.",
    "92f1": "row 04, column 00, with white underlined text.",
    "92f2": "row 04, column 04, with plain white text.",
    "9273": "row 04, column 04, with white underlined text.",
    "92f4": "row 04, column 08, with plain white text.",
    "9275": "row 04, column 08, with white underlined text.",
    "9276": "row 04, column 12, with plain white text.",
    "92f7": "row 04, column 12, with white underlined text.",
    "92f8": "row 04, column 16, with plain white text.",
    "9279": "row 04, column 16, with white underlined text.",
    "927a": "row 04, column 20, with plain white text.",
    "92fb": "row 04, column 20, with white underlined text.",
    "92fc": "row 04, column 24, with plain white text.",
    "92fd": "row 04, column 24, with white underlined text.",
    "92fe": "row 04, column 28, with plain white text.",
    "927f": "row 04, column 28, with white underlined text.",
    "1540": "row 05, column 00, with plain white text.",
    "15c1": "row 05, column 00, with white underlined text.",
    "15c2": "row 05, column 00, with plain green text.",
    "1543": "row 05, column 00, with green underlined text.",
    "15c4": "row 05, column 00, with plain blue text.",
    "1545": "row 05, column 00, with blue underlined text.",
    "1546": "row 05, column 00, with plain cyan text.",
    "15c7": "row 05, column 00, with cyan underlined text.",
    "15c8": "row 05, column 00, with plain red text.",
    "1549": "row 05, column 00, with red underlined text.",
    "154a": "row 05, column 00, with plain yellow text.",
    "15cb": "row 05, column 00, with yellow underlined text.",
    "154c": "row 05, column 00, with plain magenta text.",
    "15cd": "row 05, column 00, with magenta underlined text.",
    "15ce": "row 05, column 00, with white italicized text.",
    "154f": "row 05, column 00, with white underlined italicized text.",
    "15d0": "row 05, column 00, with plain white text.",
    "1551": "row 05, column 00, with white underlined text.",
    "1552": "row 05, column 04, with plain white text.",
    "15d3": "row 05, column 04, with white underlined text.",
    "1554": "row 05, column 08, with plain white text.",
    "15d5": "row 05, column 08, with white underlined text.",
    "15d6": "row 05, column 12, with plain white text.",
    "1557": "row 05, column 12, with white underlined text.",
    "1558": "row 05, column 16, with plain white text.",
    "15d9": "row 05, column 16, with white underlined text.",
    "15da": "row 05, column 20, with plain white text.",
    "155b": "row 05, column 20, with white underlined text.",
    "15dc": "row 05, column 24, with plain white text.",
    "155d": "row 05, column 24, with white underlined text.",
    "155e": "row 05, column 28, with plain white text.",
    "15df": "row 05, column 28, with white underlined text.",
    "15e0": "row 06, column 00, with plain white text.",
    "1561": "row 06, column 00, with white underlined text.",
    "15462": "row 06, column 00, with plain green text.",
    "15e3": "row 06, column 00, with green underlined text.",
    "1564": "row 06, column 00, with plain blue text.",
    "15e5": "row 06, column 00, with blue underlined text.",
    "15e6": "row 06, column 00, with plain cyan text.",
    "1567": "row 06, column 00, with cyan underlined text.",
    "1568": "row 06, column 00, with plain red text.",
    "15e9": "row 06, column 00, with red underlined text.",
    "15ea": "row 06, column 00, with plain yellow text.",
    "156b": "row 06, column 00, with yellow underlined text.",
    "15ec": "row 06, column 00, with plain magenta text.",
    "156d": "row 06, column 00, with magenta underlined text.",
    "156e": "row 06, column 00, with white italicized text.",
    "15ef": "row 06, column 00, with white underlined italicized text.",
    "1570": "row 06, column 00, with plain white text.",
    "15f1": "row 06, column 00, with white underlined text.",
    "15f2": "row 06, column 04, with plain white text.",
    "1573": "row 06, column 04, with white underlined text.",
    "15f4": "row 06, column 08, with plain white text.",
    "1575": "row 06, column 08, with white underlined text.",
    "1576": "row 06, column 12, with plain white text.",
    "15f7": "row 06, column 12, with white underlined text.",
    "15f8": "row 06, column 16, with plain white text.",
    "1579": "row 06, column 16, with white underlined text.",
    "157a": "row 06, column 20, with plain white text.",
    "15fb": "row 06, column 20, with white underlined text.",
    "15fc": "row 06, column 24, with plain white text.",
    "15fd": "row 06, column 24, with white underlined text.",
    "15fe": "row 06, column 28, with plain white text.",
    "157f": "row 06, column 28, with white underlined text.",
    "1640": "row 07, column 00, with plain white text.",
    "16c1": "row 07, column 00, with white underlined text.",
    "16c2": "row 07, column 00, with plain green text.",
    "1643": "row 07, column 00, with green underlined text.",
    "16c4": "row 07, column 00, with plain blue text.",
    "1645": "row 07, column 00, with blue underlined text.",
    "1646": "row 07, column 00, with plain cyan text.",
    "16c7": "row 07, column 00, with cyan underlined text.",
    "16c8": "row 07, column 00, with plain red text.",
    "1649": "row 07, column 00, with red underlined text.",
    "164a": "row 07, column 00, with plain yellow text.",
    "16cb": "row 07, column 00, with yellow underlined text.",
    "164c": "row 07, column 00, with plain magenta text.",
    "16cd": "row 07, column 00, with magenta underlined text.",
    "16ce": "row 07, column 00, with white italicized text.",
    "164f": "row 07, column 00, with white underlined italicized text.",
    "16d0": "row 07, column 00, with plain white text.",
    "1651": "row 07, column 00, with white underlined text.",
    "1652": "row 07, column 04, with plain white text.",
    "16d3": "row 07, column 04, with white underlined text.",
    "1654": "row 07, column 08, with plain white text.",
    "16d5": "row 07, column 08, with white underlined text.",
    "16d6": "row 07, column 12, with plain white text.",
    "1657": "row 07, column 12, with white underlined text.",
    "1658": "row 07, column 16, with plain white text.",
    "16d9": "row 07, column 16, with white underlined text.",
    "16da": "row 07, column 20, with plain white text.",
    "165b": "row 07, column 20, with white underlined text.",
    "16dc": "row 07, column 24, with plain white text.",
    "165d": "row 07, column 24, with white underlined text.",
    "165e": "row 07, column 28, with plain white text.",
    "16df": "row 07, column 28, with white underlined text.",
    "16e0": "row 08, column 00, with plain white text.",
    "1661": "row 08, column 00, with white underlined text.",
    "16462": "row 08, column 00, with plain green text.",
    "16e3": "row 08, column 00, with green underlined text.",
    "1664": "row 08, column 00, with plain blue text.",
    "16e5": "row 08, column 00, with blue underlined text.",
    "16e6": "row 08, column 00, with plain cyan text.",
    "1667": "row 08, column 00, with cyan underlined text.",
    "1668": "row 08, column 00, with plain red text.",
    "16e9": "row 08, column 00, with red underlined text.",
    "16ea": "row 08, column 00, with plain yellow text.",
    "166b": "row 08, column 00, with yellow underlined text.",
    "16ec": "row 08, column 00, with plain magenta text.",
    "166d": "row 08, column 00, with magenta underlined text.",
    "166e": "row 08, column 00, with white italicized text.",
    "16ef": "row 08, column 00, with white underlined italicized text.",
    "1670": "row 08, column 00, with plain white text.",
    "16f1": "row 08, column 00, with white underlined text.",
    "16f2": "row 08, column 04, with plain white text.",
    "1673": "row 08, column 04, with white underlined text.",
    "16f4": "row 08, column 08, with plain white text.",
    "1675": "row 08, column 08, with white underlined text.",
    "1676": "row 08, column 12, with plain white text.",
    "16f7": "row 08, column 12, with white underlined text.",
    "16f8": "row 08, column 16, with plain white text.",
    "1679": "row 08, column 16, with white underlined text.",
    "167a": "row 08, column 20, with plain white text.",
    "16fb": "row 08, column 20, with white underlined text.",
    "16fc": "row 08, column 24, with plain white text.",
    "16fd": "row 08, column 24, with white underlined text.",
    "16fe": "row 08, column 28, with plain white text.",
    "167f": "row 08, column 28, with white underlined text.",
    "9740": "row 09, column 00, with plain white text.",
    "97c1": "row 09, column 00, with white underlined text.",
    "97c2": "row 09, column 00, with plain green text.",
    "9743": "row 09, column 00, with green underlined text.",
    "97c4": "row 09, column 00, with plain blue text.",
    "9745": "row 09, column 00, with blue underlined text.",
    "9746": "row 09, column 00, with plain cyan text.",
    "97c7": "row 09, column 00, with cyan underlined text.",
    "97c8": "row 09, column 00, with plain red text.",
    "9749": "row 09, column 00, with red underlined text.",
    "974a": "row 09, column 00, with plain yellow text.",
    "97cb": "row 09, column 00, with yellow underlined text.",
    "974c": "row 09, column 00, with plain magenta text.",
    "97cd": "row 09, column 00, with magenta underlined text.",
    "97ce": "row 09, column 00, with white italicized text.",
    "974f": "row 09, column 00, with white underlined italicized text.",
    "97d0": "row 09, column 00, with plain white text.",
    "9751": "row 09, column 00, with white underlined text.",
    "9752": "row 09, column 04, with plain white text.",
    "97d3": "row 09, column 04, with white underlined text.",
    "9754": "row 09, column 08, with plain white text.",
    "97d5": "row 09, column 08, with white underlined text.",
    "97d6": "row 09, column 12, with plain white text.",
    "9757": "row 09, column 12, with white underlined text.",
    "9758": "row 09, column 16, with plain white text.",
    "97d9": "row 09, column 16, with white underlined text.",
    "97da": "row 09, column 20, with plain white text.",
    "975b": "row 09, column 20, with white underlined text.",
    "97dc": "row 09, column 24, with plain white text.",
    "975d": "row 09, column 24, with white underlined text.",
    "975e": "row 09, column 28, with plain white text.",
    "97df": "row 09, column 28, with white underlined text.",
    "97e0": "row 10, column 00, with plain white text.",
    "9761": "row 10, column 00, with white underlined text.",
    "9762": "row 10, column 00, with plain green text.",
    "97e3": "row 10, column 00, with green underlined text.",
    "9764": "row 10, column 00, with plain blue text.",
    "97e5": "row 10, column 00, with blue underlined text.",
    "97e6": "row 10, column 00, with plain cyan text.",
    "9767": "row 10, column 00, with cyan underlined text.",
    "9768": "row 10, column 00, with plain red text.",
    "97e9": "row 10, column 00, with red underlined text.",
    "97ea": "row 10, column 00, with plain yellow text.",
    "976b": "row 10, column 00, with yellow underlined text.",
    "97ec": "row 10, column 00, with plain magenta text.",
    "976d": "row 10, column 00, with magenta underlined text.",
    "976e": "row 10, column 00, with white italicized text.",
    "97ef": "row 10, column 00, with white underlined italicized text.",
    "9770": "row 10, column 00, with plain white text.",
    "97f1": "row 10, column 00, with white underlined text.",
    "97f2": "row 10, column 04, with plain white text.",
    "9773": "row 10, column 04, with white underlined text.",
    "97f4": "row 10, column 08, with plain white text.",
    "9775": "row 10, column 08, with white underlined text.",
    "9776": "row 10, column 12, with plain white text.",
    "97f7": "row 10, column 12, with white underlined text.",
    "97f8": "row 10, column 16, with plain white text.",
    "9779": "row 10, column 16, with white underlined text.",
    "977a": "row 10, column 20, with plain white text.",
    "97fb": "row 10, column 20, with white underlined text.",
    "97fc": "row 10, column 24, with plain white text.",
    "97fd": "row 10, column 24, with white underlined text.",
    "97fe": "row 10, column 28, with plain white text.",
    "977f": "row 10, column 28, with white underlined text.",
    "1040": "row 11, column 00, with plain white text.",
    "10c1": "row 11, column 00, with white underlined text.",
    "10c2": "row 11, column 00, with plain green text.",
    "1043": "row 11, column 00, with green underlined text.",
    "10c4": "row 11, column 00, with plain blue text.",
    "1045": "row 11, column 00, with blue underlined text.",
    "1046": "row 11, column 00, with plain cyan text.",
    "10c7": "row 11, column 00, with cyan underlined text.",
    "10c8": "row 11, column 00, with plain red text.",
    "1049": "row 11, column 00, with red underlined text.",
    "104a": "row 11, column 00, with plain yellow text.",
    "10cb": "row 11, column 00, with yellow underlined text.",
    "104c": "row 11, column 00, with plain magenta text.",
    "10cd": "row 11, column 00, with magenta underlined text.",
    "10ce": "row 11, column 00, with white italicized text.",
    "104f": "row 11, column 00, with white underlined italicized text.",
    "10d0": "row 11, column 00, with plain white text.",
    "1051": "row 11, column 00, with white underlined text.",
    "1052": "row 11, column 04, with plain white text.",
    "10d3": "row 11, column 04, with white underlined text.",
    "1054": "row 11, column 08, with plain white text.",
    "10d5": "row 11, column 08, with white underlined text.",
    "10d6": "row 11, column 12, with plain white text.",
    "1057": "row 11, column 12, with white underlined text.",
    "1058": "row 11, column 16, with plain white text.",
    "10d9": "row 11, column 16, with white underlined text.",
    "10da": "row 11, column 20, with plain white text.",
    "105b": "row 11, column 20, with white underlined text.",
    "10dc": "row 11, column 24, with plain white text.",
    "105d": "row 11, column 24, with white underlined text.",
    "105e": "row 11, column 28, with plain white text.",
    "10df": "row 11, column 28, with white underlined text.",
    "1340": "row 12, column 00, with plain white text.",
    "13c1": "row 12, column 00, with white underlined text.",
    "13c2": "row 12, column 00, with plain green text.",
    "1343": "row 12, column 00, with green underlined text.",
    "13c4": "row 12, column 00, with plain blue text.",
    "1345": "row 12, column 00, with blue underlined text.",
    "1346": "row 12, column 00, with plain cyan text.",
    "13c7": "row 12, column 00, with cyan underlined text.",
    "13c8": "row 12, column 00, with plain red text.",
    "1349": "row 12, column 00, with red underlined text.",
    "134a": "row 12, column 00, with plain yellow text.",
    "13cb": "row 12, column 00, with yellow underlined text.",
    "134c": "row 12, column 00, with plain magenta text.",
    "13cd": "row 12, column 00, with magenta underlined text.",
    "13ce": "row 12, column 00, with white italicized text.",
    "134f": "row 12, column 00, with white underlined italicized text.",
    "13d0": "row 12, column 00, with plain white text.",
    "1351": "row 12, column 00, with white underlined text.",
    "1352": "row 12, column 04, with plain white text.",
    "13d3": "row 12, column 04, with white underlined text.",
    "1354": "row 12, column 08, with plain white text.",
    "13d5": "row 12, column 08, with white underlined text.",
    "13d6": "row 12, column 12, with plain white text.",
    "1357": "row 12, column 12, with white underlined text.",
    "1358": "row 12, column 16, with plain white text.",
    "13d9": "row 12, column 16, with white underlined text.",
    "13da": "row 12, column 20, with plain white text.",
    "135b": "row 12, column 20, with white underlined text.",
    "13dc": "row 12, column 24, with plain white text.",
    "135d": "row 12, column 24, with white underlined text.",
    "135e": "row 12, column 28, with plain white text.",
    "13df": "row 12, column 28, with white underlined text.",
    "13e0": "row 13, column 00, with plain white text.",
    "1361": "row 13, column 00, with white underlined text.",
    "13462": "row 13, column 00, with plain green text.",
    "13e3": "row 13, column 00, with green underlined text.",
    "1364": "row 13, column 00, with plain blue text.",
    "13e5": "row 13, column 00, with blue underlined text.",
    "13e6": "row 13, column 00, with plain cyan text.",
    "1367": "row 13, column 00, with cyan underlined text.",
    "1368": "row 13, column 00, with plain red text.",
    "13e9": "row 13, column 00, with red underlined text.",
    "13ea": "row 13, column 00, with plain yellow text.",
    "136b": "row 13, column 00, with yellow underlined text.",
    "13ec": "row 13, column 00, with plain magenta text.",
    "136d": "row 13, column 00, with magenta underlined text.",
    "136e": "row 13, column 00, with white italicized text.",
    "13ef": "row 13, column 00, with white underlined italicized text.",
    "1370": "row 13, column 00, with plain white text.",
    "13f1": "row 13, column 00, with white underlined text.",
    "13f2": "row 13, column 04, with plain white text.",
    "1373": "row 13, column 04, with white underlined text.",
    "13f4": "row 13, column 08, with plain white text.",
    "1375": "row 13, column 08, with white underlined text.",
    "1376": "row 13, column 12, with plain white text.",
    "13f7": "row 13, column 12, with white underlined text.",
    "13f8": "row 13, column 16, with plain white text.",
    "1379": "row 13, column 16, with white underlined text.",
    "137a": "row 13, column 20, with plain white text.",
    "13fb": "row 13, column 20, with white underlined text.",
    "13fc": "row 13, column 24, with plain white text.",
    "13fd": "row 13, column 24, with white underlined text.",
    "13fe": "row 13, column 28, with plain white text.",
    "137f": "row 13, column 28, with white underlined text.",
    "9440": "row 14, column 00, with plain white text.",
    "94c1": "row 14, column 00, with white underlined text.",
    "94c2": "row 14, column 00, with plain green text.",
    "9443": "row 14, column 00, with green underlined text.",
    "94c4": "row 14, column 00, with plain blue text.",
    "9445": "row 14, column 00, with blue underlined text.",
    "9446": "row 14, column 00, with plain cyan text.",
    "94c7": "row 14, column 00, with cyan underlined text.",
    "94c8": "row 14, column 00, with plain red text.",
    "9449": "row 14, column 00, with red underlined text.",
    "944a": "row 14, column 00, with plain yellow text.",
    "94cb": "row 14, column 00, with yellow underlined text.",
    "944c": "row 14, column 00, with plain magenta text.",
    "94cd": "row 14, column 00, with magenta underlined text.",
    "94ce": "row 14, column 00, with white italicized text.",
    "944f": "row 14, column 00, with white underlined italicized text.",
    "94d0": "row 14, column 00, with plain white text.",
    "9451": "row 14, column 00, with white underlined text.",
    "9452": "row 14, column 04, with plain white text.",
    "94d3": "row 14, column 04, with white underlined text.",
    "9454": "row 14, column 08, with plain white text.",
    "94d5": "row 14, column 08, with white underlined text.",
    "94d6": "row 14, column 12, with plain white text.",
    "9457": "row 14, column 12, with white underlined text.",
    "9458": "row 14, column 16, with plain white text.",
    "94d9": "row 14, column 16, with white underlined text.",
    "94da": "row 14, column 20, with plain white text.",
    "945b": "row 14, column 20, with white underlined text.",
    "94dc": "row 14, column 24, with plain white text.",
    "945d": "row 14, column 24, with white underlined text.",
    "945e": "row 14, column 28, with plain white text.",
    "94df": "row 14, column 28, with white underlined text.",
    "94e0": "row 15, column 00, with plain white text.",
    "9461": "row 15, column 00, with white underlined text.",
    "9462": "row 15, column 00, with plain green text.",
    "94e3": "row 15, column 00, with green underlined text.",
    "9464": "row 15, column 00, with plain blue text.",
    "94e5": "row 15, column 00, with blue underlined text.",
    "94e6": "row 15, column 00, with plain cyan text.",
    "9467": "row 15, column 00, with cyan underlined text.",
    "9468": "row 15, column 00, with plain red text.",
    "94e9": "row 15, column 00, with red underlined text.",
    "94ea": "row 15, column 00, with plain yellow text.",
    "946b": "row 15, column 00, with yellow underlined text.",
    "94ec": "row 15, column 00, with plain magenta text.",
    "946d": "row 15, column 00, with magenta underlined text.",
    "946e": "row 15, column 00, with white italicized text.",
    "94ef": "row 15, column 00, with white underlined italicized text.",
    "9470": "row 15, column 00, with plain white text.",
    "94f1": "row 15, column 00, with white underlined text.",
    "94f2": "row 15, column 04, with plain white text.",
    "9473": "row 15, column 04, with white underlined text.",
    "94f4": "row 15, column 08, with plain white text.",
    "9475": "row 15, column 08, with white underlined text.",
    "9476": "row 15, column 12, with plain white text.",
    "94f7": "row 15, column 12, with white underlined text.",
    "94f8": "row 15, column 16, with plain white text.",
    "9479": "row 15, column 16, with white underlined text.",
    "947a": "row 15, column 20, with plain white text.",
    "94fb": "row 15, column 20, with white underlined text.",
    "94fc": "row 15, column 24, with plain white text.",
    "94fd": "row 15, column 24, with white underlined text.",
    "94fe": "row 15, column 28, with plain white text.",
    "947f": "row 15, column 28, with white underlined text.",
    "97a1": "Tab Offset 1 column",
    "97a2": "Tab Offset 2 columns",
    "9723": "Tab Offset 3 columns",
    "94a1": "BackSpace",
    "94a4": "Delete to End of Row",
    "94ad": "Carriage Return",
    "1020": "Background White",
    "10a1": "Background Semi-Transparent White",
    "10a2": "Background Green",
    "1023": "Background Semi-Transparent Green",
    "10a4": "Background Blue",
    "1025": "Background Semi-Transparent Blue",
    "1026": "Background Cyan",
    "10a7": "Background Semi-Transparent Cyan",
    "10a8": "Background Red",
    "1029": "Background Semi-Transparent Red",
    "102a": "Background Yellow",
    "10ab": "Background Semi-Transparent Yellow",
    "102c": "Background Magenta",
    "10ad": "Background Semi-Transparent Magenta",
    "10ae": "Background Black",
    "102f": "Background Semi-Transparent Black",
    "97ad": "Background Transparent",
    "97a4": "Standard Character Set",
    "9725": "Double-Size Character Set",
    "9726": "First Private Character Set",
    "97a7": "Second Private Character Set",
    "97a8": "People`s Republic of China Character Set",
    "9729": "Korean Standard Character Set",
    "972a": "First Registered Character Set",
    "9120": "White",
    "91a1": "White Underline",
    "91a2": "Green",
    "9123": "Green Underline",
    "91a4": "Blue",
    "9125": "Blue Underline",
    "9126": "Cyan",
    "91a7": "Cyan Underline",
    "91a8": "Red",
    "9129": "Red Underline",
    "912a": "Yellow",
    "91ab": "Yellow Underline",
    "912c": "Magenta",
    "91ad": "Magenta Underline",
    "97ae": "Black",
    "972f": "Black Underline",
    "91ae": "Italics",
    "912f": "Italics Underline",
    "94a8": "Flash ON",
    "9423": "Alarm Off",
    "94a2": "Alarm On"
}


def translate_scc(scc_content, brackets='[]'):
    """
    Replaces hexadecimal words with their meaning

    In order to make SCC files more human readable and easier to debug,
    this function is used to replace command codes with their labels and
    character bytes with their actual characters

    :param scc_content: SCC captions to be translated
    :type scc_content: str
    :param brackets: Brackets to group the translated content of a command
    :type brackets: str
    :return: Translated SCC captions
    :rtype: str
    """
    opening_bracket, closing_bracket = brackets if brackets else ('', '')
    scc_elements = set(scc_content.split())
    for elem in scc_elements:
        name = COMMAND_LABELS.get(elem)
        # If a 2 byte command was not found, try retrieving 1 byte characters
        if not name:
            char1 = ALL_CHARACTERS.get(elem[:2])
            char2 = ALL_CHARACTERS.get(elem[2:])
            if char1 is not None and char2 is not None:
                name = f"{char1}{char2}"
        if name:
            scc_content = scc_content.replace(
                elem, f"{opening_bracket}{name}{closing_bracket}")
    return scc_content
