/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.totp;

import com.google.common.primitives.Longs;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TOTPGenerator {
    public static final long DEFAULT_START_TIME = 0L;
    public static final long DEFAULT_TIME_STEP = 30L;
    private final Mode mode;
    private final Key key;
    private final int length;
    private final long startTime;
    private final long timeStep;

    public TOTPGenerator(byte[] key, Mode mode, int length, long startTime, long timeStep) throws InvalidKeyException {
        if (length < 6 || length > 8) {
            throw new IllegalArgumentException("TOTP codes must be at least 6 digits and no more than 8 digits.");
        }
        this.key = new SecretKeySpec(key, "RAW");
        this.mode = mode;
        this.length = length;
        this.startTime = startTime;
        this.timeStep = timeStep;
        TOTPGenerator.getMacInstance(this.mode, this.key);
    }

    public TOTPGenerator(byte[] key, Mode mode, int length) throws InvalidKeyException {
        this(key, mode, length, 0L, 30L);
    }

    private static Mac getMacInstance(Mode mode, Key key) throws InvalidKeyException {
        try {
            Mac hmac = Mac.getInstance(mode.getAlgorithmName());
            hmac.init(key);
            return hmac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Support for the HMAC algorithm required for TOTP in " + (Object)((Object)mode) + " mode is missing.", e);
        }
    }

    private byte[] getHMAC(byte[] message) {
        try {
            return TOTPGenerator.getMacInstance(this.mode, this.key).doFinal(message);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Provided key became invalid after passing validation.", e);
        }
    }

    private String toCode(int value, int length) {
        String valueString = Integer.toString(value);
        if (valueString.length() > length) {
            return valueString.substring(valueString.length() - length);
        }
        StringBuilder builder = new StringBuilder(length);
        for (int i = valueString.length(); i < length; ++i) {
            builder.append('0');
        }
        builder.append(valueString);
        return builder.toString();
    }

    public String generate(long time) {
        long counter = (time - this.startTime) / this.timeStep;
        byte[] hash = this.getHMAC(Longs.toByteArray(counter));
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        return this.toCode(binary, this.length);
    }

    public String generate() {
        return this.generate(System.currentTimeMillis() / 1000L);
    }

    public String previous(long time) {
        return this.generate(Math.max(this.startTime, time - this.timeStep));
    }

    public String previous() {
        return this.previous(System.currentTimeMillis() / 1000L);
    }

    public static enum Mode {
        SHA1("HmacSHA1", 20),
        SHA256("HmacSHA256", 32),
        SHA512("HmacSHA512", 64);

        private final String algorithmName;
        private final int recommendedKeyLength;

        private Mode(String algorithmName, int recommendedKeyLength) {
            this.algorithmName = algorithmName;
            this.recommendedKeyLength = recommendedKeyLength;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public int getRecommendedKeyLength() {
            return this.recommendedKeyLength;
        }
    }
}

